package itez.kit;

import java.util.List;
import com.google.common.collect.Lists;

public class EByte {

	/**
	 * 计算字符串的字节长度
	 * @param str
	 * @return
	 */
	public static int getStringByteLength(String str) {
		return EStr.isEmpty(str) ? 0 : str.getBytes(EStr.UTF_8).length;
	}
	
	/**
	 * 计算字符的字节长度
	 * @param chr
	 * @return
	 */
	public static int getCharByteLength(char chr) {
		String str = String.valueOf(chr);
		return getStringByteLength(str);
	}
	
	/**
	 * 从字符串的开始位置截取指定字节数的子串
	 * @param str
	 * @param begin
	 * @param count
	 * @param counts
	 * @return
	 */
	public static String subStringByte(String str, int begin, int count, int[] counts){
		if(EStr.isEmpty(str)) return str;
		if(count <= 0) return str;
		if(begin < 0) begin = 0;
		StringBuilder buff = new StringBuilder();
    	char[] chars = str.toCharArray();
    	char chr;
    	int chrLen = 0, dstLen = 0, dstLenPrev = 0, endLen = begin + count;
    	for(int i = 0, len = chars.length; i < len; i++){
    		chr = chars[i];
    		chrLen = getCharByteLength(chr);
    		dstLenPrev = dstLen + chrLen;
    		if(dstLen >= begin && dstLenPrev <= endLen){
    			buff.append(chr);
    			dstLen = dstLenPrev;
    		}else if(dstLenPrev <= endLen){
    			dstLen = dstLenPrev;
    		}else{
    			break;
    		}
    	}
    	counts[0] = dstLen - begin;
    	return buff.toString();
	}
	
	/**
	 * 从字符串的开始位置截取指定字节数的子串
	 * @param str
	 * @param begin
	 * @param count
	 * @return
	 */
	public static String subStringByte(String str, int begin, int count){
		return subStringByte(str, begin, count, new int[]{count});
	}
	
	/**
	 * 从字符串的开始位置截取指定字节数的子串
	 * @param str
	 * @param count
	 * @return
	 */
	public static String subStringByte(String str, int count){
		return subStringByte(str, 0, count, new int[]{count});
	}
	
	/**
	 * 将字符串，按照指定的字节数分割成多个子串
	 * @param str
	 * @param count
	 * @return
	 */
	public static List<String> splitByte(String str, int count){
		List<String> strs = Lists.newArrayList();
		int strLen = getStringByteLength(str);
		int splitLen = 0;
		int[] counts = new int[]{0};
		while(splitLen < strLen){
			String strSub = subStringByte(str, splitLen, count, counts);
			strs.add(strSub);
			splitLen += counts[0];
		}
		return strs;
	}

	public static void main(String[] args) {
		String str = "我爱ni的a中国hi在辽阳";
		System.out.println("原始字符串：" + str);
		String str1 = subStringByte(str, 7);
		System.out.println(str1);
		List<String> strs = splitByte(str, 5);
		for(String s : strs){
			System.out.println(s);
		}
	}

}
