/**
 * EBase64.java
 */
package itez.kit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;

/**
 * <p>
 * BASE64工具类
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月28日 下午2:40:53
 */
public class EBase64 {

	/**
	 * <p>
	 * BASE64编码
	 * </p>
	 * 
	 * @param data 要编码的字符串
	 * @return 编码之后的字符串
	 */
	public static String encode(String data){
		byte[] bytes = data.getBytes(EStr.UTF_8);
		return encode(bytes);
	}

	/**
	 * <p>
	 * BASE64编码
	 * </p>
	 * 
	 * @param data 要编码的字节数组
	 * @return 编码之后的字符串
	 */
	public static String encode(byte[] data){
		return Base64.getUrlEncoder().encodeToString(data);
	}

	/**
	 * <p>
	 * BASE64编码
	 * </p>
	 * 
	 * @param data 要编码的字符串
	 * @return 编码之后的字节数组
	 */
	public static byte[] encode2Byte(String data){
		byte[] bytes = data.getBytes(EStr.UTF_8);
		return encode2Byte(bytes);
	}

	/**
	 * <p>
	 * BASE64编码
	 * </p>
	 * 
	 * @param data 要编码的字节数组
	 * @return 编码之后的字节数组
	 */
	public static byte[] encode2Byte(byte[] data){
		return Base64.getUrlEncoder().encode(data);
	}
	
	/**
	 * <p>
	 * BASE64解码
	 * </p>
	 * 
	 * @param data 待解码的字符串
	 * @return 解码之后的字符串
	 */
	public static String decode(String data){
		byte[] bytes = decode2byte(data);
		return new String(bytes, EStr.UTF_8);
	}
	
	/**
	 * <p>
	 * BASE64解码
	 * </p>
	 * 
	 * @param data 待解码的字节数组
	 * @return 解码之后的字符串
	 */
	public static String decode(byte[] data){
		byte[] bytes = decode2byte(data);
		return new String(bytes, EStr.UTF_8);
	}
	
	/**
	 * <p>
	 * BASE64解码
	 * </p>
	 * 
	 * @param data 待解码的字符串
	 * @return 解码之后的字节数组
	 */
	public static byte[] decode2byte(String data){
		return Base64.getUrlDecoder().decode(data);
	}
	
	/**
	 * <p>
	 * BASE64解码
	 * </p>
	 * 
	 * @param data 待解码的字节数组
	 * @return 解码之后的字节数组
	 */
	public static byte[] decode2byte(byte[] data){
		return Base64.getUrlDecoder().decode(data);
	}
	
	/**
	 * <p>
	 * 图片转BASE64
	 * </p>
	 * 
	 * @param imgPath 图片本地路径
	 * @return 编码之后的字符串
	 */
	public static String img2str(String imgPath){
		InputStream in = null;
		try {
			in = new FileInputStream(imgPath);
			byte[] data = new byte[in.available()];
			in.read(data);
			return encode(data);
		} catch (FileNotFoundException e) {
			return null;
		} catch (IOException e) {
			return null;
		} finally {
			try {
				in.close();
			} catch (IOException e) {
			}
		}
	}
		
	/**
	 * BASE64转图片
	 * @param imgData BASE64字符串
	 * @param imgPath 图片生成路径
	 * @return 图片本地路径
	 */
	public static String str2img(String imgData, String imgPath){
		if(EStr.isEmpty(imgData) || EStr.isEmpty(imgPath)) return null;
		OutputStream out = null;
		try {
			imgData = removePrefix(imgData);
			byte[] b = Base64.getMimeDecoder().decode(imgData);
			for (int i = 0; i < b.length; ++i) {
				if (b[i] < 0) b[i] += 256;
			}
			out = new FileOutputStream(imgPath);
			out.write(b);
			return imgPath;
		} catch (Exception e) {
			return null;
		} finally {
			try {
				out.flush();
				out.close();
			} catch(IOException e){
			}
		}
	}
	
	/**
	 * 返回图片类型
	 * @param imgBase64 图片编码
	 * @return 图片类型（jpeg/gif/png等）
	 */
	public static String getImgType(String imgBase64){
		String preStr = "base64,";
		int preInd = imgBase64.indexOf(preStr);
		if(preInd > 0){
			preStr = imgBase64.substring(0, preInd - 1);
			return preStr.substring(preStr.indexOf("/") + 1);
		}else{
			return null;
		}
	}
	
	/**
	 * 删除图片编码中的前缀（base64,）
	 * @param imgBase64 图片编码
	 * @return 删除前缀之后的图片编码
	 */
	public static String removePrefix(String imgBase64){
		String preStr = "base64,";
		int preInd = imgBase64.indexOf(preStr);
		if(preInd > 0) imgBase64 = imgBase64.substring(preStr.length() + preInd);
		return imgBase64;
	}
	
	/**
	 * 向图片编码中添加jpg类型前缀
	 * @param imgBase64 图片编码
	 * @return 添加前缀之后的图片编码
	 */
	public static String addPrefix(String imgBase64){
		return addPrefix(imgBase64, "jpg");
	}
	
	/**
	 * 向图片编码中添加指定类型的前缀
	 * @param imgBase64 图片编码
	 * @param imgType 图片类型（jpeg/gif/png等）
	 * @return 添加前缀之后的图片编码
	 */
	public static String addPrefix(String imgBase64, String imgType){
		String preStr = "base64,";
		int preInd = imgBase64.indexOf(preStr);
		if(preInd < 0) imgBase64 = "data:image/" + imgType + ";base64," + imgBase64;
		return imgBase64;
	}
	
}
