/**
 * Copyright (c) 2015-2018, Michael Yang 杨福海 (fuhai999@gmail.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package itez.kit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.ArrayUtils;

/**
 * 数组工具类
 * @author netwild
 *
 */
public class EArr {

	/**
	 * 判断不是空列表
	 * @param list 列表对象
	 * @return true：不为空，false：空列表
	 */
    public static boolean isNotEmpty(List<?> list) {
        return list != null && list.size() > 0;
    }

    /**
     * 判断不是空集合
     * @param map 集合对象
     * @return true：不为空，false：空集合
     */
    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    /**
     * 判断不是空数组
     * @param objects 对象数组
     * @return true：不为空，false：空数组
     */
    public static boolean isNotEmpty(Object[] objects) {
        return objects != null && objects.length > 0;
    }

    /**
     * 判断是空列表
     * @param list 列表对象
     * @return true：空数组，false：不为空
     */
    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.size() == 0;
    }

    /**
     * 判断是空集合
     * @param map 集合对象
     * @return true：空集合，false：不为空
     */
    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    /**
     * 判断是空数组
     * @param objects 对象数组
     * @return true：空数组，false：不为空
     */
    public static boolean isNullOrEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }
    
    /**
     * 判断数组中是否含有指定值
     * @param arr 数组
     * @param key 值
     * @return true：含有指定值，false：不含有指定值
     */
    public static boolean has(Object[] arr, Object key){
    	return ArrayUtils.contains(arr, key);
    }
    
    /**
     * 判断多个整型数组中是否全部为1
     * @param arrs 多个整型数组
     * @return true：不含0，false：含有0
     */
    public static boolean vali(int[]...arrs){
    	return !valiCustom(0, arrs);
    }
    
    /**
     * 判断多个整型数组中是否至少含有一个1
     * @param arrs 多个整型数组
     * @return true：含有1，false：不含1
     */
    public static boolean valiAny(int[]...arrs){
    	return valiCustom(1, arrs);
    }
    
    /**
     * 判断一个二维整型数组中是否含有指定值
     * @param val 要比较的值
     * @param arrs 二维整型数组
     * @return true：含有指定值，false：不含有指定值
     */
    public static boolean valiCustom(int val, int[]...arrs){
    	boolean ret = false;
    	for(int[] arr : arrs){
    		boolean r = ArrayUtils.contains(arr, val);
    		if(r){
    			ret = true;
    			break;
    		}
    	}
    	return ret;
    }

    /**
     * 数组拼接
     * @param <T> 数组类型
     * @param first 第一个要拼接的数组
     * @param rest 其他要拼接的数组
     * @return 拼接之后的新数组
     */
    @SafeVarargs
	public static <T> T[] concat(T[] first, T[]... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

}
