package itez.core.wrapper.routes;

import java.util.ArrayList;
import java.util.List;

import com.jfinal.config.Routes;

import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager.ControllerConfig;
import itez.core.wrapper.controller.EController;
import itez.kit.ELog;
import itez.kit.log.ELogBase;
import itez.plat.wrapper.controller.EControllerSite;

public class ERoutes extends Routes {

	private final static ELogBase log = ELog.log(ERoutes.class);
	private ModuleBase moduleConfig = null;
	private List<ControllerConfig> controllers = new ArrayList<ControllerConfig>();
	
	public ERoutes(ModuleBase moduleConfig, List<ControllerConfig> controllers){
		this.moduleConfig = moduleConfig;
		this.controllers = controllers;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void config() {
		String baseViewPath = moduleConfig.getModuleView() + "/temp";
		//网站相关的controller模板文件单独放置
		if(!moduleConfig.getModuleCode().equals("site")) setBaseViewPath(baseViewPath);
		controllers.forEach(controller -> {
			String clazz = controller.getClassName();
			String key = controller.getKey();
			String view = controller.getView();
			try {
				Class<? extends EController> c = (Class<? extends EController>) Class.forName(clazz);
				if(!moduleConfig.getModuleCode().equals("site")){
					add(this.moduleConfig.getModulePath() + key, c, view);
				}else if(EControllerSite.class.isAssignableFrom(c)){
					add(this.moduleConfig.getModulePath() + key, c, view);
				}else
					add(this.moduleConfig.getModulePath() + key, c, baseViewPath + view);
			} catch (ClassNotFoundException e) {
				log.error("初始化控制器时发生错误：{}，{}", clazz, e.getMessage());
			}
		});
	}

}
