package itez.core.wrapper.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import com.jfinal.render.ContentType;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.template.Engine;

/**
 * <p>
 * 模板渲染
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年10月24日 下午9:43:10
 */
public abstract class ERender extends Render {

	protected static final String DEFAULT_CONTENT_TYPE = "text/plain";

	protected String contentType;

	public String getContentType() {
		return contentType + "; charset=" + getEncoding();
	}
	
	public void setContentType(ContentType contentType) {
		this.contentType = contentType.value();
	}
	
	/**
	 * 通用渲染输出
	 * @param engine
	 */
	protected void renderEvent(Engine engine){
		response.setContentType(getContentType());
		Map<Object, Object> data = getReqData();
		try {
			OutputStream os = response.getOutputStream();
			engine.getTemplate(view).render(data, os);
		} catch (RuntimeException e) {	// 捕获 ByteWriter.close() 抛出的 RuntimeException
			Throwable cause = e.getCause();
			if (cause instanceof IOException) {	// ClientAbortException、EofException 直接或间接继承自 IOException
				String name = cause.getClass().getSimpleName();
				if ("ClientAbortException".equals(name) || "EofException".equals(name)) {
					return ;
				}
			}
			throw e;
		} catch (IOException e) {
			throw new RenderException(e);
		}
	}
	
	/**
	 * <p>
	 * 返回页面参数
	 * </p>
	 * 
	 * @return
	 */
	protected Map<Object, Object> getReqData(){
		Map<Object, Object> data = new HashMap<Object, Object>();
		for (Enumeration<String> attrs = request.getAttributeNames(); attrs.hasMoreElements();) {
			String attrName = attrs.nextElement();
			data.put(attrName, request.getAttribute(attrName));
		}
		return data;
	}

}
