package itez.core.wrapper.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;

import com.jfinal.captcha.Captcha;
import com.jfinal.captcha.CaptchaManager;
import com.jfinal.captcha.CaptchaRender;
import com.jfinal.kit.LogKit;
import com.jfinal.render.RenderException;

import itez.kit.ECookie;

public class ECaptchaRender extends CaptchaRender {

	public ECaptchaRender() {
		captchaName = "_JWCAP_";
	}
	
	@Override
	public void render() {
		Captcha captcha = createCaptcha();
		CaptchaManager.me().getCaptchaCache().put(captcha);
		
//		Cookie cookie = new Cookie(captchaName, captcha.getKey());
//		cookie.setMaxAge(-1);
//		cookie.setPath("/");
//		response.addCookie(cookie);
		
		ECookie.setCookie(response, captchaName, captcha.getKey(), -1, TimeUnit.SECONDS);
		
		response.setHeader("Pragma","no-cache");
		response.setHeader("Cache-Control","no-cache");
		response.setDateHeader("Expires", 0);
		response.setContentType("image/jpeg");
		
		ServletOutputStream sos = null;
		try {
			BufferedImage image = new BufferedImage(WIDTH, HEIGHT, BufferedImage.TYPE_INT_RGB);
			drawGraphic(captcha.getValue(), image);
			
			sos = response.getOutputStream();
			ImageIO.write(image, "jpeg", sos);
		} catch (IOException e) {
			if (getDevMode()) {
				throw new RenderException(e);
			}
		} catch (Exception e) {
			throw new RenderException(e);
		} finally {
			if (sos != null) {
				try {sos.close();} catch (IOException e) {LogKit.logNothing(e);}
			}
		}
	}
	
}
