package itez.core.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.auth.AuthCode;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.session.ESessionBase;
import itez.core.wrapper.controller.EController;
import itez.kit.restful.Result;

/**
 * <p>
 * 超管身份验证
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年4月10日 下午3:27:28
 */
public class SuperAuthInterceptor implements Interceptor {

	@Override
	public void intercept(Invocation inv) {
		EController ctrl = (EController)inv.getController();
		ESessionBase sess = ctrl.session();
		IUser user = sess.getUser();
		if(null == user){
			sendErr(ctrl, "未登录！");
			return;
		}
		if(!user.checkSupAdmin()){
			sendErr(ctrl, "该资源仅允许超级管理员访问！");
			return;
		}
		inv.invoke();
	}
	
	private void sendErr(EController ctrl, String msg){
        String header = ctrl.getRequest().getHeader("content-type");
		boolean isJson = (header != null && header.contains("json"));
		if(isJson) ctrl.renderJson(Result.fail(msg));
		else ctrl.renderErrMsg(AuthCode.REQ_ROLE, msg);
	}

}
