package itez.core.wrapper.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.MDC;

import com.jfinal.aop.Invocation;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.CPI;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.render.RedirectRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;

import itez.core.launch.JW;
import itez.core.runtime.EContext;
import itez.core.runtime.auth.AuthCode;
import itez.core.runtime.session.EAttr;
import itez.core.runtime.session.FlashMessage;
import itez.core.wrapper.controller.EController;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EWeb;
import itez.kit.exception.ExceptionKit;
import itez.kit.log.ELogBase;
import itez.kit.restful.Result;
import itez.kit.restful.ResultCode;

/**
 * 根路由处理器
 * 
 * @author netwild
 *
 */
public class EActionHandler extends ActionHandler {

	private final static String MDC_KEY_SESS_ID = "sessionId";
	private final static String MDC_KEY_DOMAIN = "domain";
	
	private final static ELogBase log = ELog.log(EActionHandler.class);
	
	//无需打印info日志的Action
	//private final static String[] IGNORE_ACTIONS = {"/plat/valicode", "/plat/qrcode", "/plat/ueditorUpload"};
	
	@Override
	public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
		if(!JW.getLicenseVali()) return;
		if(target.indexOf(".") != -1) return;
		isHandled[0] = true;
		String[] urlPara = {null};
		Action action = actionMapping.getAction(target, urlPara);
		if (action == null) {
			if (log.isWarnEnabled()) {
				String qs = request.getQueryString();
				log.warn("无效的访问地址：" + (qs == null ? target : target + "?" + qs));
			}
			request.setAttribute("attr", EContext.getAttr());
			renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
			return ;
		}
		EController controller = null;
		try {
			controller = (EController)controllerFactory.getController(action.getControllerClass());
			CPI._init_(controller, action, request, response, urlPara[0]);
			HttpSession sess = request.getSession();
            EAttr attr = EContext.getAttr();
            controller.setAttr("attr", attr.Caller(controller));
            controller.setAttr("session", sess);
            MDC.put(MDC_KEY_SESS_ID, sess.getId());
            MDC.put(MDC_KEY_DOMAIN, attr.getDomain());
    		invocation(request, target, controller, action);
			Render render = controller.getRender();
			if (render instanceof ForwardActionRender) {
				String actionUrl = ((ForwardActionRender)render).getActionUrl();
				if (!target.equals(actionUrl)) handle(actionUrl, request, response, isHandled);
				return ;
			}
			if (render == null) {
				String view = action.getViewPath() + action.getMethodName();
				render = renderManager.getRenderFactory().getDefaultRender(view);
			}
            if (render instanceof RedirectRender) {
            	FlashMessage.me.store(controller);
            }else{
            	FlashMessage.me.render(controller);
            }
			render.setContext(request, response, action.getViewPath()).render();
		}
		catch (RenderException e) {
			if (log.isErrorEnabled()) {
				String qs = request.getQueryString();
				log.error(qs == null ? target : target + "?" + qs, e);
			}
		}
		catch (ActionException e) {
			int errorCode = e.getErrorCode();
			String msg = null;
			if (errorCode == 404) {
				msg = "404 Not Found: ";
			} else if (errorCode == 401) {
				msg = "401 Unauthorized: ";
			} else if (errorCode == 403) {
				msg = "403 Forbidden: ";
			}
			
			if (msg != null) {
				if (log.isWarnEnabled()) {
					String qs = request.getQueryString();
					log.warn(msg + (qs == null ? target : target + "?" + qs));
				}
			} else {
				if (log.isErrorEnabled()) {
					String qs = request.getQueryString();
					log.error(qs == null ? target : target + "?" + qs, e);
				}
			}
			e.getErrorRender().setContext(request, response, action.getViewPath()).render();
		}
		catch (Exception e) {
			if (log.isErrorEnabled()) {
				String qs = request.getQueryString();
				log.error(qs == null ? target : target + "?" + qs, e);
			}
			renderManager.getRenderFactory().getErrorRender(500).setContext(request, response, action.getViewPath()).render();
		} finally {
			MDC.remove(MDC_KEY_SESS_ID);
			MDC.remove(MDC_KEY_DOMAIN);
			if (controller != null) CPI._clear_(controller);
		}
	}
	
	private void invocation(HttpServletRequest req, String target, EController controller, Action action){
        EAttr attr = EContext.getAttr();
		try {
			//关闭请求日志，由防火墙中的溯源日志取缔
			/**
			if(!ArrayUtils.contains(IGNORE_ACTIONS, target)){
				log.info("请求信息：[target]{} [query]{} [ip]{} [port]{}", target, EStr.ifNull(req.getQueryString(), ""), EWeb.getIpAddr(req), EWeb.getRemotePort(req));
			}
			*/
			if (devMode) {
				if (EActionReporter.isReportAfterInvocation(req)) {
					new Invocation(action, controller).invoke();
					EActionReporter.report(target, controller, action);
				} else {
					EActionReporter.report(target, controller, action);
					new Invocation(action, controller).invoke();
				}
			}
			else {
				new Invocation(action, controller).invoke();
			}
		} catch (Exception e) {
			String errMsg = e.getMessage();
			if(EStr.isEmpty(errMsg)) errMsg = "运行时发生未知错误！";
			if(attr.getIsAjax() || attr.getIsWxa()){
				controller.renderJson(Result.fail(ResultCode.ERR_RUNTIME, errMsg));
			}else{
				controller.renderErrMsg(AuthCode.RUNTIME, EProp.ErrorDetailDisplay ? errMsg : "请稍后再次重试！");
			}
			if(EProp.DevMode){
				e.printStackTrace();
			}else{
				log.error("错误请求：{}", EWeb.getFullUrl(req));
				log.error("错误描述：{}", ExceptionKit.getExceptionMore(e));
			}
		}
	}
	
}
