package itez.core.wrapper.dbo.tx;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

import com.beust.jcommander.internal.Maps;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;

import itez.kit.ELog;

public class ETx implements Interceptor {

	private void getConfigWithAnno(Map<String, Config> configs, Module module, Modules modules){
		if(module != null){
			Config cfg = DbKit.getConfig(module.value());
			if(cfg != null) configs.put(cfg.getName(), cfg);
		}else if(modules != null){
			Module[] moduleArr = modules.value();
			Arrays.stream(moduleArr).forEach(m -> {
				Config cfg = DbKit.getConfig(m.value());
				if(cfg != null) configs.put(cfg.getName(), cfg);
			});
		}
	}
	
	private Map<String, Config> getConfigWithModule(Invocation inv) {
		Map<String, Config> configs = Maps.newHashMap();
		Module module = inv.getMethod().getAnnotation(Module.class);
		Modules modules = inv.getMethod().getAnnotation(Modules.class);
		getConfigWithAnno(configs, module, modules);
		if(configs.size() == 0){
			module = inv.getTarget().getClass().getAnnotation(Module.class);
			modules = inv.getTarget().getClass().getAnnotation(Modules.class);
			getConfigWithAnno(configs, module, modules);
		}
		if(configs.size() == 0) {
			Config cfg = DbKit.getConfig();
			configs.put(cfg.getName(), cfg);
		}
		return configs;
	}
	
	private int getTransactionLevel(Config config) {
		return config.getTransactionLevel();
	}
	
	private boolean doThreadLocalConn(Collection<Config> configs){
		boolean[] hasLocalConn = {false};
		configs.stream().forEach(cfg -> {
			Connection conn = cfg.getThreadLocalConnection();
			int txLevel = getTransactionLevel(cfg);
			if(conn != null){
				hasLocalConn[0] = true;
				try {
					if(conn.getTransactionIsolation() < txLevel) conn.setTransactionIsolation(txLevel);
				} catch (SQLException e) {
					throw new ActiveRecordException(e);
				}
			}
		});
		return hasLocalConn[0];
	}
	
	@Override
	public void intercept(Invocation inv) {
		Map<String, Config> configMap = getConfigWithModule(inv);
		Map<String, Boolean> autoCommits = Maps.newHashMap();
		Collection<Config> configs = configMap.values();
		
		//处理嵌套的事务
		if(doThreadLocalConn(configs)){
			inv.invoke();
			return ;
		}
		
		try {
			for(Config cfg : configs){
				Connection conn = cfg.getConnection();
				autoCommits.put(cfg.getName(), conn.getAutoCommit());
				cfg.setThreadLocalConnection(conn);
				conn.setTransactionIsolation(getTransactionLevel(cfg));
				conn.setAutoCommit(false);
			}
			
			inv.invoke();
			
			for(Config cfg : configs){
				Connection conn = cfg.getConnection();
				conn.commit();
			}
		} catch (NestedTransactionHelpException e) {
			try {
				for(Config cfg : configs){
					Connection conn = cfg.getConnection();
					if (conn != null) conn.rollback();
				}
			} catch (SQLException ex) {
				ELog.error(ex.getMessage());
			}
		} catch (Throwable t) {
			try {
				for(Config cfg : configs){
					Connection conn = cfg.getConnection();
					if (conn != null) conn.rollback();
				}
				throw t instanceof RuntimeException ? (RuntimeException)t : new ActiveRecordException(t);
			}catch(SQLException e){
				ELog.error(e.getMessage());
			}
		} finally {
			try {
				for(Config cfg : configs){
					Connection conn = cfg.getConnection();
					if (conn != null){
						Boolean autoCmt = autoCommits.get(cfg.getName());
						if(autoCmt != null){
							conn.setAutoCommit(autoCmt);
							conn.close();
						}
					}
				}
			} catch (SQLException e) {
				ELog.error(e.getMessage());
			} finally {
				for(Config cfg : configs){
					cfg.removeThreadLocalConnection();
				}
			}
		}
	}

}
