package itez.core.wrapper.dbo.plugin;

import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect.DbType;
import itez.kit.EProp;

import java.util.Properties;

import javax.sql.DataSource;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.jfinal.plugin.druid.DruidPlugin;

public class EDruidPlugin extends DruidPlugin {

	private DbType dbType = DbType.mysql;
	private boolean useInformationSchema = false;
	private boolean useFilterStat = false;
	private boolean useFilterWall = false;
	private boolean isStarted = false;
	
	public EDruidPlugin(DbProp prop){
		this(prop, false);
	}
	
	public EDruidPlugin(DbProp prop, boolean useInformationSchema){
		this(prop, useInformationSchema, false, false);
	}
	
	public EDruidPlugin(DbProp prop, boolean useInformationSchema, boolean useFilterStat, boolean useFilterWall){
		super(prop.getJdbcUrl(), prop.getUserName(), prop.getPassWord(), prop.getDriverClass());
		
		this.dbType = prop.getType();
		this.useFilterStat = useFilterStat;
		this.useFilterWall = useFilterWall;
		this.setFilter();
		
		int initialSize = prop.getInitialSize();
		int minIdle = prop.getMinIdle();
		int maxActive = prop.getMaxActive();
		super.set(initialSize, minIdle, maxActive);
		
		this.setUseInformationSchema(useInformationSchema);
	}
	
	public EDruidPlugin(String url, String username, String password, String driverClass) {
		super(url, username, password, driverClass);
	}

	public EDruidPlugin(String url, String username, String password, String driverClass, DbType dbType, boolean useFilterStat, boolean useFilterWall) {
		super(url, username, password, driverClass);
		this.dbType = dbType;
		this.useFilterStat = useFilterStat;
		this.useFilterWall = useFilterWall;
		this.setFilter();
	}
	
	private void setFilter(){
		
		//SQL格式化日志输出
		if(EProp.DevMode && EProp.DevPrintSQL){
			EDruidFilter sqlFormat = new EDruidFilter();
			addFilter(sqlFormat);
		}
		
		//启用监控统计过滤器
		if(this.useFilterStat){
			StatFilter stat = new StatFilter();
			stat.setMergeSql(true);		//目前已通过EDruidFilter进行日志打印
			stat.setLogSlowSql(true);
			stat.setSlowSqlMillis(500L);
			stat.setDbType(dbType.toString());
			addFilter(stat);
			
			/*
			Slf4jLogFilter log = new Slf4jLogFilter();
			log.setDataSourceLogEnabled(false);
			log.setConnectionLogEnabled(false);
			log.setConnectionLogErrorEnabled(false);
			log.setConnectionConnectBeforeLogEnabled(false);
			log.setConnectionConnectAfterLogEnabled(false);
			log.setConnectionCommitAfterLogEnabled(false);
			log.setConnectionRollbackAfterLogEnabled(false);
			log.setConnectionCloseAfterLogEnabled(false);
			log.setStatementLogEnabled(false);
			log.setStatementLogErrorEnabled(true);
			log.setStatementCreateAfterLogEnabled(false);
			log.setStatementPrepareAfterLogEnabled(false);
			log.setStatementPrepareCallAfterLogEnabled(false);
			log.setStatementExecutableSqlLogEnable(true);
			log.setStatementExecuteAfterLogEnabled(false);
			log.setStatementExecuteQueryAfterLogEnabled(false);
			log.setStatementExecuteUpdateAfterLogEnabled(false);
			log.setStatementExecuteBatchAfterLogEnabled(false);
			log.setStatementCloseAfterLogEnabled(false);
			log.setStatementParameterSetLogEnabled(false);
			log.setResultSetLogEnabled(false);
			log.setResultSetLogErrorEnabled(false);
			log.setResultSetNextAfterLogEnabled(false);
			log.setResultSetOpenAfterLogEnabled(false);
			log.setResultSetCloseAfterLogEnabled(false);
			addFilter(log);
			*/
		}
		
		//启用防SQL注入过滤器
		if(this.useFilterWall){ 
			WallConfig config = new WallConfig();
			config.setFunctionCheck(false); // 支持数据库函数
			WallFilter wall = new WallFilter();
			wall.setDbType(dbType.toString());
			wall.setConfig(config);
			addFilter(wall);
			
			//SQL格式化日志输出
			EDruidFilter sqlFormat = new EDruidFilter();
			addFilter(sqlFormat);
		}
		
		//租户SQL隔离，未调试完成，暂不启用
//		DomainFilter domainFilter = new DomainFilter();
//		addFilter(domainFilter);
	}
	
	@Override
	public DataSource getDataSource() {
		DruidDataSource dataSource = (DruidDataSource)super.getDataSource();
		dataSource.setDbType(this.dbType.name());
		if(this.useInformationSchema){ //允许使用元数据库
			Properties properties = new Properties();
			properties.setProperty("remarks", "true");
			properties.setProperty("useInformationSchema", "true");
			dataSource.setConnectProperties(properties);
		}
		
		return dataSource;
	}
	
	@Override
	public boolean start() {
		try {
			super.start();
			isStarted = true;
		} catch (Exception e) {
			//EContext.getController().setFlashMsg("数据库连接失败：" + e.getMessage());
			e.printStackTrace();
			isStarted = false;
		}
		return isStarted;
	}
	
	@Override
	public boolean stop() {
		if(super.stop()) isStarted = false;
		return true;
	}

	public boolean isUseInformationSchema() {
		return useInformationSchema;
	}

	public void setUseInformationSchema(boolean useInformationSchema) {
		this.useInformationSchema = useInformationSchema;
	}

	public DbType getDbType() {
		return dbType;
	}

	public boolean isUseFilterStat() {
		return useFilterStat;
	}

	public boolean isUseFilterWall() {
		return useFilterWall;
	}

	public boolean isStarted() {
		return isStarted;
	}

}
