/**
 * EDruidFilter.java
 */
package itez.core.wrapper.dbo.plugin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;

import itez.kit.EDate;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;

/**
 * <p>
 * 类描述
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年2月1日 下午3:29:10
 */
@SuppressWarnings("unused")
public class EDruidFilter extends FilterAdapter {

	private static final ELogBase log = ELog.log(EDruidFilter.class);
	private static final boolean devMode = EProp.DevMode;
	
	@Override
	public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
		super.statement_close(chain, statement);
		
		String sql = statement.getBatchSql();
		if(sql.isEmpty()) return;
		
		int parametersSize = statement.getParametersSize();
		if (parametersSize > 0) {
            int elapsed = (int) statement.getLastExecuteTimeNano() / (1000 * 1000); //消耗时间（毫秒）
			List<Object> parameters = new ArrayList<>(parametersSize);
			for(int i = 0; i < parametersSize; ++i) {
                JdbcParameter jdbcParam = statement.getParameter(i);
                parameters.add(jdbcParam != null ? jdbcParam.getValue() : null);
            }
			String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
			sql = SQLUtils.format(sql, dbType, parameters, SQLUtils.DEFAULT_LCASE_FORMAT_OPTION);
			printSQL(sql, elapsed);
		}
	}
	
	public void printSQL(String sql, int elapsed){
        String sb = "\n"
                  + "JWinner SQL report -------- "
        		  + EDate.format(EDate.getDate(), EDate.PATTERN_YMD_HMS)
        		  + "(Elapsed : " + elapsed + " ms)"
                  + " ---------------\n"
                  + sql.trim()
                  + "\n--------------------------------------------------------------------------------\n";
//        if(devMode) System.out.println(sb);
//        else log.info(sb);
        System.out.println(sb);
    }
	
}
