package itez.core.wrapper.dbo.plugin;

import java.util.List;
import java.util.Map;

import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.stat.TableStat.Name;
import com.google.common.collect.Maps;
import com.jfinal.plugin.activerecord.generator.TableMeta;

import itez.core.runtime.EContext;
import itez.core.runtime.session.EAttr;
import itez.core.wrapper.dbo.DbUtil;

public class DomainFilter extends FilterEventAdapter {
	
	final static Map<String, Boolean> tablesMeta = Maps.newConcurrentMap();
	final static String TENANT_COLUMN_NAME = "domain";

	@Override
	protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
		DataSourceProxy ds = statement.getConnectionProxy().getDirectDataSource();
		String connName = ds.getName();
		String dbType = ds.getDbType();
		EAttr attr = EContext.getAttr();
		if(null != attr){
			String domain = EContext.getAttr().getDomain();
			List<SQLStatement> stmts  = SQLUtils.parseStatements(sql, dbType);
			SchemaStatVisitor schema = new SchemaStatVisitor();
			TenantASTVisitor tenant = new TenantASTVisitor(connName, domain);
			for(SQLStatement stmt : stmts){
				Boolean skip = true;
				stmt.accept(schema);
				Map<Name, TableStat> tables = schema.getTables();
				for(Name tableName : tables.keySet()){
					if(tableName.getName().equals("base_session")) break;
					if(tableName.getName().equals("base_user")) break;
					String key = String.format("%s_%s", connName, tableName.getName());
					if(tablesMeta.containsKey(key)){
						if(tablesMeta.get(key)) skip = false;
					}else{
						TableMeta meta = DbUtil.getTableMetaBy(connName, tableName.getName());
						boolean hasTenant = meta.columnMetas.stream().anyMatch(columnMeta -> columnMeta.name.equals(TENANT_COLUMN_NAME));
						tablesMeta.put(key, hasTenant);
						if(hasTenant) skip = false;
					}
				}
				if(skip) continue;
				stmt.accept(tenant);
			}
		}
		super.statementExecuteQueryBefore(statement, sql);
	}

	@SuppressWarnings("unused")
	class TenantASTVisitor extends MySqlASTVisitorAdapter{
		
		private String connName;
		private String domain;
		
		TenantASTVisitor(String connName, String domain){
			this.connName = connName;
			this.domain = domain;
		}
		
		@Override
		public boolean visit(SQLExprTableSource x) {
			System.out.println("table: " + x.toString());
			return super.visit(x);
		}
		
		@Override
		public boolean visit(SQLSelectQueryBlock x) {
			System.out.println(x.toString());
			return super.visit(x);
		}
		
	}
	
}
