package itez.core.wrapper.dbo.model;

import java.io.Serializable;

public class Query implements Serializable {
	
	private static final long serialVersionUID = 4393699885873048442L;
    
    public static enum LOGIC {
    	
    	LIKE(" LIKE ")
    	, GT(" > ")				//Greater Than
    	, GE(" >= ")			//Greater than Or Equals
    	, LT(" < ")				//Less Than
    	, LE(" <= ")			//Less than Or Equals
    	, EQ(" = ")				//Equals
    	, NE(" != ")			//Not Equals
    	, NU(" IS ")			//IS NULL
    	, NN(" IS NOT ")		//IS NOT NULL
    	, IN(" IN ")			//IN
    	, FIN(" FIND_IN_SET");	//FIND_IN_SET
    	
    	private String sign;
    	
    	LOGIC(String sign){
    		this.sign = sign;
    	}
    	
    	public String getSign(){
    		return this.sign;
    	}
    }

    private String name;
    private Object value;
    private LOGIC logic = LOGIC.EQ;

    /**
     * 新建查找条件
     * @param name
     * @param value
     * @param logic
     * @return
     */
    public static Query create(String name, Object value, LOGIC logic) {
        Query Query = new Query();
        Query.setName(name);
        Query.setValue(value);
        Query.setLogic(logic);
        return Query;
    }
    
    /**
     * 模块匹配
     * @param name
     * @param value
     * @return
     */
    public static Query like(String name, Object value){
    	return create(name, value, LOGIC.LIKE);
    }
    
    /**
     * 大于
     * @param name
     * @param value
     * @return
     */
    public static Query gt(String name, Object value){
    	return create(name, value, LOGIC.GT);
    }
    
    /**
     * 大于等于
     * @param name
     * @param value
     * @return
     */
    public static Query ge(String name, Object value){
    	return create(name, value, LOGIC.GE);
    }
    
    /**
     * 小于
     * @param name
     * @param value
     * @return
     */
    public static Query lt(String name, Object value){
    	return create(name, value, LOGIC.LT);
    }
    
    /**
     * 小于等于
     * @param name
     * @param value
     * @return
     */
    public static Query le(String name, Object value){
    	return create(name, value, LOGIC.LE);
    }
    
    /**
     * 等于
     * @param name
     * @param value
     * @return
     */
    public static Query eq(String name, Object value){
    	return create(name, value, LOGIC.EQ);
    }
    
    /**
     * 不等于
     * @param name
     * @param value
     * @return
     */
    public static Query ne(String name, Object value){
    	return create(name, value, LOGIC.NE);
    }
    
    /**
     * 等于null
     * @param name
     * @return
     */
    public static Query nu(String name){
    	return create(name, null, LOGIC.NU);
    }
    
    /**
     * 不等于null
     * @param name
     * @return
     */
    public static Query nn(String name){
    	return create(name, null, LOGIC.NN);
    }
    
    /**
     * 在其中之一
     * @param name
     * @param value
     * @return
     */
    public static Query in(String name, String value){
    	return create(name, value, LOGIC.IN);
    }
    
    /**
     * FIND_IN_SET：与字段中的某一个值匹配
     * @param name
     * @param value
     * @return
     */
    public static Query fin(String name, String value){
    	return create(name, value, LOGIC.FIN);
    }

    public Query logic(LOGIC logic) {
        this.setLogic(logic);
        return this;
    }
    
    public boolean hasArg(){
    	if(logic == LOGIC.NU || logic == LOGIC.NN || logic == LOGIC.IN) return false;
    	return true;
    }
    

    
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public LOGIC getLogic() {
        return logic;
    }

    public void setLogic(LOGIC logic) {
        this.logic = logic;
    }
}
