package itez.core.wrapper.dbo.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.generator.BaseModelGenerator;
import com.jfinal.plugin.activerecord.generator.TableMeta;

public class EServiceInterfaceGenerator extends BaseModelGenerator {

	String servicePackage;
	String modelPackage;
	
	public EServiceInterfaceGenerator(String servicePackage, String serviceOutputDir, String modelPackage) {
		super(servicePackage, serviceOutputDir);
		this.servicePackage = servicePackage;
		this.modelPackage = modelPackage;
		template = "/itez/core/wrapper/dbo/generator/temp/service_interface_template.jw";
	}

    @Override
	protected void genBaseModelContent(TableMeta tableMeta) {
		Kv data = Kv.by("baseModelPackageName", baseModelPackageName);
		data.set("generateChainSetter", generateChainSetter);
		data.set("tableMeta", tableMeta);
        data.set("servicePackage", servicePackage);
        data.set("modelPackage", modelPackage);
		tableMeta.baseModelContent = engine.getTemplate(template).renderToString(data);
	}

    @Override
    protected void writeToFile(TableMeta tableMeta) throws IOException {
        File dir = new File(baseModelOutputDir);
        if (!dir.exists()) dir.mkdirs();

        String target = baseModelOutputDir + File.separator + tableMeta.modelName + "Service" + ".java";

        File targetFile = new File(target);
        if (targetFile.exists()) return;

        FileWriter fw = new FileWriter(target);
        try {
            fw.write(tableMeta.baseModelContent);
        } finally {
            fw.close();
        }
    }

}
