package itez.core.wrapper.dbo.generator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.sql.DataSource;

import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import com.jfinal.plugin.activerecord.generator.MetaBuilder;
import com.jfinal.plugin.activerecord.generator.TableMeta;

public class EMetaBuilder extends MetaBuilder {

	protected String[] filterTables;
	
	public EMetaBuilder(DataSource dataSource, String... filterTables) {
		super(dataSource);
		this.filterTables = filterTables;
	}

	/**
	 * 获取数据表（排除视图view）
	 */
	@Override
	protected ResultSet getTablesResultSet() throws SQLException {
		String schemaPattern = dialect instanceof OracleDialect ? dbMeta.getUserName() : null;
		return dbMeta.getTables(conn.getCatalog(), schemaPattern, null, new String[]{"TABLE"});
	}
	
	/**
	 * 根据前缀对表格进行筛选
	 * 未设置前缀或者符合前缀的表格应该给予生成，不跳过，则返回false
	 * 设置了前缀，但当前表格名称不带该前缀的，不应该生成，即跳过，则返回true
	 * 
	 * @param tableName 生成器遍历时传入的当前表格名称
	 */
	@Override
	protected boolean isSkipTable(String tableName) {
		if(this.filterTables != null && this.filterTables.length > 0){ //设置了有效的前缀
			for(String tablePrefix : filterTables){
				if(tableName.startsWith(tablePrefix)) return false; //表格符合前缀，则生成
			}
			return true; //表格不符合前缀筛选，则跳过不生成
		}else{
			return false; //未设置有效的前缀筛选规则，则生成全部表格
		}
	}
	
	/**
	 * <p>
	 * 根据正则表达式进行表格排除
	 * </p>
	 * 
	 * @param tableName
	 * @return
	 */
	protected boolean isExcludeTable(String tableName) {
		if(this.excludedTables != null && this.excludedTables.size() > 0){ //设置了有效的表达式
			for(String excluded : excludedTables){
				if(tableName.matches(excluded)) return true; //表格符合忽略规则，则跳过不生成
			}
			return false; //表格不符合忽略规则，则生成
		}else{
			return false; //未设置有效的忽略规则，则生成全部表格
		}
	}
	
	@Override
	protected void buildTableNames(List<TableMeta> ret) throws SQLException {
		ResultSet rs = getTablesResultSet();
		while (rs.next()) {
			String tableName = rs.getString("TABLE_NAME");
			if (isExcludeTable(tableName)) continue;
			if (isSkipTable(tableName)) continue ;
			
			TableMeta tableMeta = new TableMeta();
			tableMeta.name = tableName;
			tableMeta.remarks = rs.getString("REMARKS");
			
			tableMeta.modelName = buildModelName(tableName);
			tableMeta.baseModelName = buildBaseModelName(tableMeta.modelName);
			//System.out.println("发现表：" + tableMeta.name + "（" + tableMeta.remarks + "）");
			ret.add(tableMeta);
		}
		rs.close();
	}

}
