package itez.core.wrapper.dbo.generator;

import java.util.List;

import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.generator.MappingKitGenerator;
import com.jfinal.plugin.activerecord.generator.TableMeta;

public class EMappingKitGenerator extends MappingKitGenerator {

	protected String template = "/itez/core/wrapper/dbo/generator/temp/mapping_kit_template.jw";
	
	private String modulePackageName = null;
	
	public EMappingKitGenerator(String modulePackageName, String mappingKitPackageName, String mappingKitOutputDir) {
		super(mappingKitPackageName, mappingKitOutputDir);
		super.template = template;
		this.modulePackageName = modulePackageName;
	}
	
	@Override
	public void generate(List<TableMeta> tableMetas) {
		System.out.println("Generate MappingKit file ...");
		System.out.println("MappingKit Output Dir: " + mappingKitOutputDir);
		
		Kv data = Kv.by("mappingKitPackageName", mappingKitPackageName);
		data.set("mappingKitClassName", mappingKitClassName);
		data.set("tableMetas", tableMetas);
		data.set("modulePackageName", modulePackageName);
		
		String ret = engine.getTemplate(template).renderToString(data);
		writeToFile(ret);
	}

}
