/**
 * 
 */
package itez.core.wrapper.dbo.exec;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.jfinal.plugin.activerecord.Record;

import itez.kit.EProp;

/**
 * <p>
 * 结果集
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年4月13日 下午10:31:43
 */
public class DbTable implements Serializable {

	private static final long serialVersionUID = 5211557591688363731L;
	
	private List<DbField> fields;
	private List<Record> records;
	
	public DbTable(){
		fields = Lists.newArrayList();;
		records = Lists.newArrayList();
	}
	
	public DbTable(ResultSetMetaData metas, List<Record> recs){
		fields = Lists.newArrayList();
		this.records = recs;
		try {
			int fieldCnt = metas.getColumnCount();
			for(int i = 1; i <= fieldCnt; i++){
				fields.add(new DbField(i - 1, metas.getColumnName(i), metas.getColumnType(i), metas.getColumnTypeName(i), metas.getColumnDisplaySize(i)));
			}
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
		}
	}

	public List<DbField> getFields() {
		return fields;
	}

	public List<Record> getRecords() {
		return records;
	}
	
}
