package itez.core.wrapper.dbo.dialect;

import com.jfinal.plugin.activerecord.dialect.OracleDialect;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.kit.exception.ErrException;

import java.util.List;
import java.util.stream.Collectors;


public class OracleDialectImpl extends OracleDialect implements IDialect {

	@Override
	public String genQuery(String table, String loadColumns, Querys qs, String groupBy, String orderBy, Object limit) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        sqlBuilder.append(loadColumns).append(" FROM ").append(table).append(" ");
        querysFormat(" WHERE ", qs, sqlBuilder);
        if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
        if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
        if (limit == null) return sqlBuilder.toString();
        if (limit instanceof Number) {
            StringBuilder ret = new StringBuilder();
            ret.append("select * from ( select row_.*, rownum rownum_ from (  ");
            ret.append(sqlBuilder);
            ret.append(" ) row_ where rownum <= ").append(limit).append(") table_alias");
            return ret.toString();
        } else if (limit instanceof String && limit.toString().contains(",")) {
            String[] startAndEnd = limit.toString().split(",");
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            StringBuilder ret = new StringBuilder();
            ret.append("select * from ( select row_.*, rownum rownum_ from (  ");
            ret.append(sqlBuilder);
            ret.append(" ) row_ where rownum <= ").append(end).append(") table_alias");
            ret.append(" where table_alias.rownum_ > ").append(start);
            return ret.toString();
        } else {
            throw new ErrException("sql limit is error!,limit must is Number of String like \"0,10\"");
        }
	}

	@Override
	public String genPageSelect(String loadColumns) {
		return "SELECT " + loadColumns;
	}

	@Override
	public String genPageQuery(String table, Querys qs, String groupBy, String orderBy) {
		StringBuilder sqlBuilder = new StringBuilder(" FROM ").append(table);
		querysFormat(" WHERE ", qs, sqlBuilder);
        if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
		return sqlBuilder.toString();
	}
    
    private void querysFormat(String prefix, Querys querys, StringBuilder sqlBuilder) {
    	if(querys == null) return;
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		
		boolean hasQuery = querys.queryValid();
		boolean hasQuerys = querys.querysValid();
		if(!hasQuery && !hasQuerys) return;
		boolean brackets = qList.size() > 1 || (hasQuery && hasQuerys);
		
		sqlBuilder.append(prefix);
		if(brackets) sqlBuilder.append(" ( ");
		prefix = " ".concat(querys.getLogic().getSign()).concat(" ");
			
		if(hasQuery){
			sqlBuilder.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(querys.getLogic().getSign())));
			prefix = querys.getLogic().getSign();
		}else{
			prefix = "";
		}
		
		if(hasQuerys){
			for(Querys qs : qsList){
				querysFormat(prefix, qs, sqlBuilder);
				prefix = querys.getLogic().getSign();
			}
		}
		
		if(brackets) sqlBuilder.append(" ) ");
    }
    
    private String queryTemp(Query q){
    	String temp;
    	if(q.getLogic() == Query.LOGIC.NU || q.getLogic() == Query.LOGIC.NN){
    		temp = String.format("%s%snull", q.getName(), q.getLogic().getSign());
    	}else if(q.getLogic() == Query.LOGIC.IN){
    		temp = String.format("%s%s(%s)", q.getName(), q.getLogic().getSign(), q.getValue());
    	}else if(q.getLogic() == Query.LOGIC.FIN){
    		temp = String.format("%s(?, `%s`)", q.getLogic().getSign(), q.getName());
    	}else{
    		temp = String.format("%s%s?", q.getName(), q.getLogic().getSign());
    	}
    	return temp;
    }

}
