package itez.core.wrapper.dbo.dialect;

import com.jfinal.plugin.activerecord.dialect.MysqlDialect;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ERegex;
import itez.kit.EStr;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


public class MysqlDialectImpl extends MysqlDialect implements IDialect {

	@Override
	public String genQuery(String table, String loadColumns, Querys qs, String groupBy, String orderBy, Object limit) {
		loadColumns = genColumns(loadColumns);
		StringBuilder sqlBuilder = new StringBuilder("SELECT ");
		sqlBuilder.append(loadColumns).append(" FROM  `").append(table).append("` ");
        boolean[] start = { true };
		querysFormat(start, null, qs, sqlBuilder);
		if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
        if (limit != null) sqlBuilder.append(" LIMIT ").append(limit);
        return sqlBuilder.toString();
	}

	@Override
	public String genPageSelect(String loadColumns) {
		loadColumns = genColumns(loadColumns);
		return "SELECT " + loadColumns;
	}

	@Override
	public String genPageQuery(String table, Querys qs, String groupBy, String orderBy){
        StringBuilder sqlBuilder = new StringBuilder(" FROM `").append(table).append("`");
        boolean[] start = { true };
		querysFormat(start, null, qs, sqlBuilder);
		if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
		return sqlBuilder.toString();
	}
	
	private String genColumns(String columns){
		if(EStr.isEmpty(columns)) return " * ";
		String[] colArr = columns.split(",");
		columns = Arrays.stream(colArr).map(c -> ERegex.checkVar(c) ? "`".concat(c.trim()).concat("`") : c.trim()).collect(Collectors.joining(","));
		return columns;
	}
    
    private void querysFormat(boolean[] start, String prefix, Querys querys, StringBuilder sqlBuilder) {
    	if(querys == null) return;
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		
		boolean hasQuery = querys.queryValid();
		boolean hasQuerys = querys.querysValid();
		if(!hasQuery && !hasQuerys) return;
		
		String sign = querys.getLogic().getSign();
		boolean brackets = qList.size() > 1 || (hasQuery && hasQuerys);
			

    	//Querys qs1 = Querys.and();
    	//Querys qs2 = Querys.and(Query.ne("id", "ZZUVCCL600ZN6DBOXR"));
    	//Querys qs3 = Querys.or(Query.in("code", "21011101")).add(Query.in("caption", "运营G211"));
    	//Querys qs4 = Querys.or(Query.nu("domain")).add(Query.eq("domain", "saip"));
    	
    	//qs2.add(qs3);
    	//qs1.add(qs2).add(qs4);
		
		if(hasQuery){
			if(start[0]){
				sqlBuilder.append(" WHERE ");
				start[0] = false;
			}else{
				sqlBuilder.append(prefix);
			}
			if(brackets) sqlBuilder.append(" ( ");
			sqlBuilder.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(sign)));
		}
		
		if(hasQuerys){
			for(Querys qs : qsList){
				querysFormat(start, sign, qs, sqlBuilder);
			}
		}
		
		if(brackets) sqlBuilder.append(" ) ");
		
    }
    
    private String queryTemp(Query q){
    	String temp;
    	if(q.getLogic() == Query.LOGIC.NU || q.getLogic() == Query.LOGIC.NN){
    		temp = String.format("`%s`%snull", q.getName(), q.getLogic().getSign());
    	}else if(q.getLogic() == Query.LOGIC.IN){
    		temp = String.format("`%s`%s(%s)", q.getName(), q.getLogic().getSign(), q.getValue());
    	}else if(q.getLogic() == Query.LOGIC.FIN){
    		temp = String.format("%s(?, `%s`)", q.getLogic().getSign(), q.getName());
    	}else{
    		temp = String.format("`%s`%s?", q.getName(), q.getLogic().getSign());
    	}
    	return temp;
    }

    public static void main(String[] args) {
		
//    	Querys qs1 = Querys.or(Query.eq("domain", "domain")).add(Query.eq("level", 2));
//		Querys qs2 = Querys.and(qs1).add(Query.eq("loginName", "loginName"));
    	
    	Querys qs = Querys.and(Querys.and(Query.eq("x", 1)));
    	Querys qsor = Querys.or(Query.nu("domain")).add(Query.eq("domain", "")).add(Query.eq("domain", "www"));
    	qs.add(qsor);
		
		//Object[] arg = qs2.getArgs();
		//System.out.println(Arrays.toString(arg));
		//System.out.println("===============================");
    	
//    	Querys qs1 = Querys.and();
//    	Querys qs2 = Querys.and(Query.ne("id", "ZZUVCCL600ZN6DBOXR"));
//    	Querys qs3 = Querys.or(Query.in("code", "21011101")).add(Query.in("caption", "运营G211"));
//    	Querys qs4 = Querys.or(Query.nu("domain")).add(Query.eq("domain", "saip"));
//    	
//    	qs2.add(qs3);
//    	qs1.add(qs2).add(qs4);
		
		MysqlDialectImpl dialect = new MysqlDialectImpl();
		String sql = dialect.genQuery("table", "*", qs, null, "sort desc", 1);
		System.out.println(sql);
	}

}
