package itez.core.wrapper.dbo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.TableMeta;

import itez.core.wrapper.dbo.model.EModel;
import itez.kit.EClass;

public class DbUtil {
	
	/**
	 * 返回表格配置
	 * 
	 * @param moduleCode 模块别名
	 * @param modelName Model名称
	 * @return
	 */
	public static TableMeta getTableMeta(String moduleCode, String modelName){
		String modelClass = String.format("itez.plat.%s.model.%s", moduleCode, modelName);
		return getTableMeta(modelClass);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param modelClass Model类路径，例如：itez.plat.base.model.Post
	 * @return
	 */
	public static TableMeta getTableMeta(String modelClass, String[] configInfo){
		EModel<?> model = null;
		try {
			model = EClass.newInstance(modelClass);
		} catch (Exception e) {
			throw new RuntimeException("未找到类型：" + modelClass);
		}
		return getTableMeta(model, configInfo);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param modelClass Model类路径，例如：itez.plat.base.model.Post
	 * @return
	 */
	public static TableMeta getTableMeta(String modelClass){
		EModel<?> model = null;
		try {
			model = EClass.newInstance(modelClass);
		} catch (Exception e) {
			throw new RuntimeException("未找到类型：" + modelClass);
		}
		return getTableMeta(model);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param modelClass Model类型
	 * @return
	 */
	public static TableMeta getTableMeta(Class<? extends EModel<?>> modelClass, String[] configInfo){
		EModel<?> model = null;
		try {
			model = EClass.newInstance(modelClass);
		} catch (Exception e) {
			throw new RuntimeException("无法实例化类型：" + modelClass);
		}
		return getTableMeta(model, configInfo);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param modelClass Model类型
	 * @return
	 */
	public static TableMeta getTableMeta(Class<? extends EModel<?>> modelClass){
		EModel<?> model = null;
		try {
			model = EClass.newInstance(modelClass);
		} catch (Exception e) {
			throw new RuntimeException("无法实例化类型：" + modelClass);
		}
		return getTableMeta(model);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param model Model对象
	 * @return
	 */
	public static TableMeta getTableMeta(EModel<?> model, String[] configInfo){
		Config config = model._getConfig();
		String tableName = model._getTable().getName();
		configInfo[0] = config.getName();
		configInfo[1] = tableName;
		return getTableMeta(config, tableName);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param model Model对象
	 * @return
	 */
	public static TableMeta getTableMeta(EModel<?> model){
		Config config = model._getConfig();
		String tableName = model._getTable().getName();
		return getTableMeta(config, tableName);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param configName 连接池名称
	 * @param tableName 表格名称
	 * @return
	 */
	public static TableMeta getTableMetaBy(String configName, String tableName){
		Config config = DbKit.getConfig(configName);
		return getTableMeta(config, tableName);
	}
	
	/**
	 * 返回表格配置
	 * 
	 * @param config 连接池配置对象
	 * @param tableName 表格名称
	 * @return
	 */
	public static TableMeta getTableMeta(Config config, String tableName){
		TableMeta tableMeta = null;
		try {
			Connection conn = config.getConnection();
			Dialect dialect = config.getDialect();
			DatabaseMetaData metaData = conn.getMetaData();
			
			//获取表格配置信息
			String schemaPattern = dialect instanceof OracleDialect ? metaData.getUserName() : null;
			String catalog = conn.getCatalog();
			ResultSet rs_tb = metaData.getTables(catalog, schemaPattern, tableName, null);
			while(rs_tb.next()){
				String name = rs_tb.getString("TABLE_NAME");
				if(name.equals(tableName)){
					tableMeta = new TableMeta();
					tableMeta.name = name;
					tableMeta.remarks = rs_tb.getString("REMARKS");
				}
			}
			
			//获取主键信息
			if(tableMeta == null) throw new Exception("未找到表格：" + tableName);
			ResultSet rs_pk = metaData.getPrimaryKeys(catalog, null, tableName);
			String primaryKey = "";
			int index = 0;
			while(rs_pk.next()){
				if(index++ > 0) primaryKey += ",";
				primaryKey += rs_pk.getString("COLUMN_NAME");
			}
			tableMeta.primaryKey = primaryKey;
			
			//获取字段信息
			ResultSet rs_col = metaData.getColumns(catalog, schemaPattern, tableName, null);
			while(rs_col.next()){
				ColumnMeta cm = new ColumnMeta();
				cm.name = rs_col.getString("COLUMN_NAME");
				cm.type = rs_col.getString("TYPE_NAME");
				cm.remarks = rs_col.getString("REMARKS");
				tableMeta.columnMetas.add(cm);
			}
			
		} catch (Exception e) {
			throw new RuntimeException(e.getMessage());
		}
		return tableMeta;
	}
	
}
