package itez.core.wrapper.dbo;

import com.jfinal.kit.Prop;

import itez.core.wrapper.dbo.dialect.EDialect;
import itez.core.wrapper.dbo.dialect.EDialect.DbType;

public class DbProp {

	private String connName;
	private String reName; //如果希望连接重用，则传入新名称，系统启动时将使用connName指定的连接池，但ARP插件名称将使用reName
	private DbType type;
	private String driverClass;
	private String jdbcUrl;
	private String userName;
	private String passWord;
	private Integer initialSize;
	private Integer minIdle;
	private Integer maxActive;
	
	public DbProp() { }
	
	public DbProp(Prop prop){
		this.connName = prop.get("DBConnName");
		this.type = EDialect.DbType.fromString(prop.get("DBType", "mysql"));
		this.driverClass = prop.get("DBDriverClass", "com.mysql.jdbc.Driver");
		this.jdbcUrl = prop.get("DBJdbcUrl", "");
		this.userName = prop.get("DBUserName", "root");
		this.passWord = prop.get("DBPassWord", "");
		this.initialSize = prop.getInt("DBInitialSize", 10);
		this.minIdle = prop.getInt("DBMinIdle", 10);
		this.maxActive = prop.getInt("DBMaxActive", 20);
	}
	
	public String getConnName() {
		return connName;
	}
	public void setConnName(String connName) {
		this.connName = connName;
	}
	public DbType getType() {
		return type;
	}
	public void setType(DbType type) {
		this.type = type;
	}
	public String getDriverClass() {
		return driverClass;
	}
	public void setDriverClass(String driverClass) {
		this.driverClass = driverClass;
	}
	public String getJdbcUrl() {
		return jdbcUrl;
	}
	public void setJdbcUrl(String jdbcUrl) {
		this.jdbcUrl = jdbcUrl;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getPassWord() {
		return passWord;
	}
	public void setPassWord(String passWord) {
		this.passWord = passWord;
	}
	public Integer getInitialSize() {
		return initialSize;
	}
	public void setInitialSize(Integer initialSize) {
		this.initialSize = initialSize;
	}
	public Integer getMinIdle() {
		return minIdle;
	}
	public void setMinIdle(Integer minIdle) {
		this.minIdle = minIdle;
	}
	public Integer getMaxActive() {
		return maxActive;
	}
	public void setMaxActive(Integer maxActive) {
		this.maxActive = maxActive;
	}
	public String getReName() {
		return reName;
	}
	public void setReName(String reName) {
		this.reName = reName;
	}
	
}
