package itez.core.wrapper.dbo;

import java.util.Map;
import java.util.Set;

import javax.sql.DataSource;

import com.google.common.collect.Maps;
import com.jfinal.config.Plugins;

import itez.core.launch.JW;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.wrapper.dbo.model.EMapping;
import itez.kit.EClass;
import itez.kit.EClassSearch;
import itez.kit.ELog;
import itez.kit.log.ELogBase;

public class DbManager {

	private static final ELogBase log = ELog.log(DbManager.class);
	public static final DbManager me = new DbManager();
	private DbManager(){}
	public final static String MAIN_DATABASE_NAME = "main";
	
	private Map<String, DataSource> moduleDataSourceMap = Maps.newHashMap();

	public void initDBPlugins(Plugins plugins){
		if(!JW.getLicenseVali()) {
			log.error("当前JWinner版本未通过授权！");
			return;
		}
		Set<Class<?>> mappingList = EClassSearch.getClassList(JW.DataModelPackage, true, EMapping.class, null);
		Map<EMapping, ModuleBase> mappingLoading = Maps.newHashMap();
		mappingList.forEach(clazz -> {
			EMapping mapping = (EMapping) EClass.newInstance(clazz);
			DbProp prop = mapping.getDataBaseConfig().getConfig();
			ModuleBase module = findModule(clazz);
			if(prop.getConnName().equals(MAIN_DATABASE_NAME) && prop.getReName() == null){
				mapping.regPlugin(plugins, module);
			}else{
				mappingLoading.put(mapping, module);
			}
		});
		mappingLoading.keySet().forEach(mapping -> {
			mapping.regPlugin(plugins, mappingLoading.get(mapping));
		});
		log.info("数据库模型映射完成");
	}
	
	private ModuleBase findModule(Class<?> clazz){
		String pkg = clazz.getPackage().getName();
		ModuleBase module = ModuleManager.me.findModuleConfig(pkg);
		if(module == null) throw new RuntimeException("未找到对应的模块配置文件：" + pkg);
		return module;
	}
	
	public void putDataSource(String moduleCode, DataSource druid){
		moduleDataSourceMap.put(moduleCode, druid);
	}
	
	public DataSource getDataSource(String moduleCode){
		return moduleDataSourceMap.get(moduleCode);
	}
	
}
