package itez.core.wrapper.cross;

import javax.servlet.http.HttpServletResponse;

import org.apache.http.HttpStatus;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.wrapper.controller.EController;
import itez.core.wrapper.controller.HTTP;

public class CrossOriginInterceptor implements Interceptor {

	@Override
	public void intercept(Invocation inv) {
		EController ctrl = (EController)inv.getController();
		boolean enableCross = inv.getMethod().isAnnotationPresent(CrossOrigin.class);
		if(!enableCross) enableCross = ctrl.getClass().isAnnotationPresent(CrossOrigin.class);
		
		if(enableCross){
			HttpServletResponse resp = ctrl.getResponse();
			handler(resp);
			if(ctrl.getMethod() == HTTP.OPTIONS){
				resp.setStatus(HttpStatus.SC_NO_CONTENT);
				ctrl.renderNull();
				return;
			}
		}
		inv.invoke();
	}

	/**
	 * 设置跨域响应
	 * 
	 * 跨域分为“普通模式”和“预检模式（Preflighted Request）”两种
	 * 
	 * 当存在以下情况时，将自动切换到“预检模式”：
	 * 1）请求方法不是GET/HEAD/POST
	 * 2）POST请求的Content-Type并非application/x-www-form-urlencoded, multipart/form-data, 或text/plain
	 * 3）请求设置了自定义的header字段
	 * 
	 *  “预检模式”的跨域，每次请求之前，都会发送一次OPTIONS请求
	 * 
	 * @param response
	 */
	private void handler(HttpServletResponse response) {
		response.setHeader("Access-Control-Allow-Origin", "*");								//允许的请求域名
		response.setHeader("Access-Control-Allow-Methods", "POST, GET");					//允许的请求方式
		response.setHeader("Access-Control-Allow-Headers", "*");							//允许的自定义头
		response.setHeader("Access-Control-Max-Age", "3600");
	}

}
