package itez.core.wrapper.controller;

import java.util.HashMap;
import java.util.Map;

import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;

import itez.core.runtime.service.ServiceManager;
import itez.kit.EClass;

public class EControllerFactory extends ControllerFactory {
	
	private ThreadLocal<Map<Class<? extends Controller>, Controller>> buffers = new ThreadLocal<Map<Class<? extends Controller>, Controller>>() {
		protected Map<Class<? extends Controller>, Controller> initialValue() {
			return new HashMap<Class<? extends Controller>, Controller>();
		}
	};

	@Override
	public Controller getController(Class<? extends Controller> controllerClass) throws InstantiationException, IllegalAccessException {
		Controller controller = buffers.get().get(controllerClass);
		if (controller == null) {
			controller = EClass.newInstance(controllerClass);
			ServiceManager.me.injectMembers(controller);
			buffers.get().put(controllerClass, controller);
		}
		return controller;
	}
	
}
