package itez.core.wrapper.controller;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;

/**
 * 控制器注解
 * 
 * @author netwild
 *
 */

@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface ControllerDefine {

	/**
	 * 控制器名称
	 * @category 控制器名称
	 * @return
	 */
    String summary();
    
	/**
	 * 控制器路径，必须以“/”开头
	 * @category 控制器路径，必须以“/”开头
	 * @return
	 */
    String key();
    
    /**
     * 视图文件子目录名称，默认与key相同
     * @category 视图文件子目录名称，默认与key相同
     * @return
     */
    String view();
    
}
