package itez.core.waf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <p>
 * Waf返回值
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年10月16日 下午5:44:18
 */
public interface IWafInfo {

	/**
	 * <p>
	 * 返回请求子域
	 * </p>
	 * 
	 * @return
	 */
	String getDomain();
	
	/**
	 * <p>
	 * 返回请求地址
	 * </p>
	 * 
	 * @return
	 */
	String getTarget();
	
	/**
	 * <p>
	 * 返回处理结果
	 * </p>
	 * 
	 * @return
	 */
	String getDesc();
	
	/**
	 * <p>
	 * 返回溯源日志
	 * </p>
	 * 
	 * @return
	 */
	IWafLog getWafLog();
	
	HttpServletRequest getRequest();
	HttpServletResponse getResponse();
	
}
