package itez.core.waf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Waf入口
 * @author netwild
 *
 */
public interface IWaf {
	
	/**
	 * <p>
	 * 收集请求信息
	 * </p>
	 * 
	 * @param domain
	 * @param target
	 * @param request
	 * @param response
	 * @return
	 */
	IWafInfo gather(String domain, String target, HttpServletRequest request, HttpServletResponse response);
	
	/**
	 * 防火墙拦截检测：请求
	 * @param target 请求路径
	 * @param request 请求对象
	 * @param response 响应对象
	 * @return
	 */
	boolean before(IWafInfo info);
	
	/**
	 * <p>
	 * 防火墙拦截检测：响应
	 * </p>
	 * 
	 * @param log
	 * @param request
	 * @param response
	 * @return
	 */
	boolean after(IWafInfo info);
	
	/**
	 * <p>
	 * 保存日志
	 * </p>
	 * 
	 * @param info
	 */
	void saveLog(IWafInfo info);
	
}
