package itez.core.util.grouping;

public class GroupingField {

	public static enum Type { STRING, NUMBER }
	public static enum Order { ASC, DESC }
	
	private String name;		//字段名称
	private String caption;		//字段名称（中文）
	private Type type;			//字段类型
	private Order order;		//排序方式（数值型默认倒序，其他类型默认升序）
	private Integer weight;		//权重（默认1，将按照权重由高到低的顺序进行分组）

	public GroupingField(String name, String caption) {
		Type type = Type.STRING;
		init(name, caption, type, type == Type.NUMBER ? Order.DESC : Order.ASC, 1);
	}

	public GroupingField(String name, String caption, Type type) {
		init(name, caption, type, type == Type.NUMBER ? Order.DESC : Order.ASC, 1);
	}
	
	public GroupingField(String name, String caption, Type type, Order order) {
		init(name, caption, type, order, 1);
	}
	
	public GroupingField(String name, String caption, Type type, Order order, Integer weight) {
		init(name, caption, type, order, weight);
	}
	
	private void init(String name, String caption, Type type, Order order, Integer weight){
		this.name = name;
		this.caption = caption;
		this.type = type;
		this.order = order;
		this.weight = weight;
	}

	public String getName() {
		return name;
	}
	public GroupingField setName(String name) {
		this.name = name;
		return this;
	}
	public String getCaption() {
		return caption;
	}
	public GroupingField setCaption(String caption) {
		this.caption = caption;
		return this;
	}
	public Type getType() {
		return type;
	}
	public GroupingField setType(Type type) {
		this.type = type;
		return this;
	}
	public Order getOrder() {
		return order;
	}
	public GroupingField setOrder(Order order) {
		this.order = order;
		return this;
	}
	public Integer getWeight() {
		return weight;
	}
	public GroupingField setWeight(Integer weight) {
		this.weight = weight;
		return this;
	}
	
}
