package itez.core.util.grouping;

import java.util.List;
import java.util.Map;

import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;

import itez.core.util.grouping.GroupingField.Order;
import itez.core.util.grouping.GroupingField.Type;
import itez.core.wrapper.dbo.DbManager;
import itez.kit.ENum;
import itez.kit.poi.XlsHeader;
import itez.kit.poi.XlsHeaderItem;
import itez.kit.poi.XlsWriter;

public class Grouping {

	protected List<Record> data;			//待分组数据
	protected GroupingPlanBase plan;		//分组方案
	
	public Grouping(GroupingPlanBase plan, List<Record> data) {
		this.plan = plan;
		this.data = data;
	}
	
	public GroupingPlanBase groupingDo(){
		plan.setData(data);
		return plan.groupingDo();
	}

	public List<Record> getData() {
		return data;
	}

	public GroupingPlanBase getPlan() {
		return plan;
	}
	
	public static void main(String[] args) {
		DbManager.me.initDBPlugins(null);
		
		String sql = "select examCode, caption, sex, pro1stCaption pro from ensp_student limit 100";
		List<Record> list = Db.find(sql);
		
		GroupingPlanBase plan = new GroupingPlanByGroupCount(4);
		plan.putField(new GroupingField("sex", "性别", Type.STRING, Order.ASC, 10));
		plan.putField(new GroupingField("pro", "专业", Type.STRING, Order.ASC, 20));
		plan.setCountWeight(30);
		
		Grouping grouping = new Grouping(plan, list);
		grouping.groupingDo();
		
		// 以上已经完成分组
		
		// 开始获取分组统计
		
		plan.groupingStis();
		Kv diff = plan.getDiff();	//总差异率
		
		// 开始将统计结果导出Excel
		
		XlsWriter xls = XlsWriter.create("GroupingTest.xls");
		XlsHeader header = XlsHeader.create();
		header.addItem(new XlsHeaderItem("examCode", "考生号"));
		header.addItem(new XlsHeaderItem("caption", "姓名"));
		header.addItem(new XlsHeaderItem("sex", "性别"));
		header.addItem(new XlsHeaderItem("pro", "专业"));
		
		List<GroupingItem> groups = plan.getGroups();
		for(GroupingItem group : groups){
			Integer index = group.getGroupIndex();
			Map<String, Kv> fieldDiff = group.getFieldDiffStis();
			List<Record> data = group.getData();
			Record fieldStis = new Record();
			fieldStis.set("caption", "字段差异率");
			for(String fieldName : plan.getFieldNames()){
				fieldStis.set(fieldName, ENum.toInt(fieldDiff.get(fieldName).getNumber("fieldDiff")));
			}
			data.add(fieldStis);
			Record stis = new Record();
			stis.set("caption", "总差异率");
			stis.set("sex", ENum.toInt(diff.getNumber("fieldDiff")));
			stis.set("pro", ENum.toInt(diff.getNumber("ratePer")) + "%");
			data.add(stis);
			
			xls.putSheet("分组".concat(index + 1 + ""), data, header);
		}
		xls.generator().export("D:/exportPic/excel");
	}
	
}
