package itez.core.util.drawing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

import itez.kit.ERegex;
import itez.kit.EStr;

public abstract class BoardElement {

	public static enum Type { TEXT, IMAGE }
	
	protected Type type;
	protected Integer x;
	protected Integer y;
	protected Integer width;
	protected Integer height;
	
	public abstract void drawing(Board board, Graphics outG);
 
    protected BufferedImage getImage(String imgPath) {
        try {
        	if(ERegex.check(imgPath, "^(http|https|HTTP|HTTPS)\\:")){
        		return ImageIO.read(new URL(imgPath));
        	}else{
                return ImageIO.read(new FileInputStream(imgPath));
        	}
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
 
    protected ImageObserver imageobserver = new ImageObserver() {
        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return true;
        }
    };
    
    protected Float parsePercent(String percentStr) {
		if(EStr.isEmpty(percentStr)) return 0f;
		percentStr = percentStr.substring(0, percentStr.length() - 1);
		return Float.parseFloat(percentStr) / 100;
	}
    
    protected void error(String msg) {
		throw new RuntimeException(msg);
	}

	public Type getType() {
		return type;
	}

	public Integer getX() {
		return x;
	}

	public Integer getY() {
		return y;
	}

	public Integer getWidth() {
		return width;
	}

	public Integer getHeight() {
		return height;
	}

}
