package itez.core.util;

import java.util.concurrent.Callable;

import itez.kit.ELog;

/**
 * 重试工具类
 * @author netwild
 *
 */
public class RetryUtils {
	
    /**
     * 回调结果检查
     */
    public interface ResultCheck {
        boolean matching();
        String getJson();
    }

    /**
     * 在遇到异常时尝试重试
     * @param retryLimit 重试次数
     * @param retryCallable 重试回调
     * @param <V> 泛型
     * @return V 结果
     */
	public static <V extends ResultCheck> V retryOnException(int retryLimit, Callable<V> retryCallable) {
        V v = null;
        for (int i = 0; i < retryLimit; i++) {
            try {
                v = retryCallable.call();
            } catch (Exception e) {
                ELog.warn("第 " + (i + 1) + " 次获取异常： v = " + (v == null ? null : v.getJson()) , e);
            }
            if (null != v && v.matching()) break;
            ELog.error("第 " + (i + 1) + " 次获取，不符合校验要求： v = " + (v == null ? null : v.getJson()));
        }
        return v;
    }

    /**
     * 在遇到异常时尝试重试
     * @param retryLimit 重试次数
     * @param sleepMillis 每次重试之后休眠的时间
     * @param retryCallable 重试回调
     * @param <V> 泛型
     * @return V 结果
     * @throws java.lang.InterruptedException 线程异常
     */
    public static <V extends ResultCheck> V retryOnException(int retryLimit, long sleepMillis, Callable<V> retryCallable) throws java.lang.InterruptedException {
        V v = null;
        for (int i = 0; i < retryLimit; i++) {
            try {
                v = retryCallable.call();
            } catch (Exception e) {
            	ELog.warn("第 " + (i + 1) + " 次获取异常： v = " + (v == null ? null : v.getJson()) , e);
            }
            if (null != v && v.matching()) break;
            ELog.error("第 " + (i + 1) + " 次获取，不符合校验要求： v = " + (v == null ? null : v.getJson()));
            Thread.sleep(sleepMillis);
        }
        return v;
    }

}
