package itez.core.util;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import com.jfinal.plugin.ehcache.IDataLoader;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.EStr;
import itez.kit.cache.ECacheFactory;
import itez.kit.cache.ICacheItem;
import itez.plat.main.model.Comp;
import itez.plat.main.service.CompService;

public class ECacheKit {
	
	public static String appendTenant(String cacheName){
		String domain = null;
		if(null != EContext.getAttr()) domain = EContext.getAttr().getDomain();
		return appendTenant(domain, cacheName);
	}
	
	public static String appendTenant(String domain, String cacheName){
		if(cacheName == null) cacheName = "_";
		if(EStr.isEmpty(domain)) return cacheName;
		return String.format("%s::%s", domain, cacheName);
	}
	
	public static String formatKey(Object key){
		if(EStr.isEmpty(key)) key = "_";
		return key.toString();
	}

	public static <T> T get(String cacheName, Object key) {
		return ECacheFactory.me.getCache().get(appendTenant(cacheName), formatKey(key));
	}

	public static <T> T get(ICacheItem item) {
		return ECacheFactory.me.getCache().get(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()));
	}

	public static void put(String cacheName, Object key, Object value) {
		ECacheFactory.me.getCache().put(appendTenant(cacheName), formatKey(key), value);
	}

	public static void put(ICacheItem item) {
		ECacheFactory.me.getCache().put(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()), item.getCacheValue(), item.getLiveSeconds());
	}

	public static void remove(String cacheName, Object key) {
		ECacheFactory.me.getCache().remove(appendTenant(cacheName), formatKey(key));
	}

	public static void remove(ICacheItem item) {
		ECacheFactory.me.getCache().remove(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()));
	}

	public static void removeAll(String cacheName) {
		ECacheFactory.me.getCache().removeAll(appendTenant(cacheName));
	}

	public static void removeAll(ICacheItem item) {
		ECacheFactory.me.getCache().removeAll(appendTenant(item.getCacheName()));
	}

	public static boolean has(String cacheName, Object key) {
		return ECacheFactory.me.getCache().has(appendTenant(cacheName), formatKey(key));
	}

	public static boolean has(ICacheItem item) {
		return ECacheFactory.me.getCache().has(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()));
	}

	public static void put(String cacheName, Object key, Object value, int liveSeconds) {
		ECacheFactory.me.getCache().put(appendTenant(cacheName), formatKey(key), value, liveSeconds);
	}

	public static void put(String cacheName, Object key, Object value, int lives, TimeUnit unit) {
		ECacheFactory.me.getCache().put(appendTenant(cacheName), formatKey(key), value, (int)unit.toSeconds(lives));
	}

	public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
		return ECacheFactory.me.getCache().get(appendTenant(cacheName), formatKey(key), dataLoader);
	}

	public static <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
		return ECacheFactory.me.getCache().get(appendTenant(cacheName), formatKey(key), dataLoader, liveSeconds);
	}

	public static Integer getTtl(String cacheName, Object key) {
		return ECacheFactory.me.getCache().getTtl(appendTenant(cacheName), formatKey(key));
	}

	public static Integer getTtl(ICacheItem item) {
		return ECacheFactory.me.getCache().getTtl(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()));
	}

	public static void setTtl(String cacheName, Object key, int seconds) {
		ECacheFactory.me.getCache().setTtl(appendTenant(cacheName), formatKey(key), seconds);
	}

	public static void setTtl(String cacheName, Object key, int lives, TimeUnit unit) {
		ECacheFactory.me.getCache().setTtl(appendTenant(cacheName), formatKey(key), (int)unit.toSeconds(lives));
	}

	public static void setTtl(ICacheItem item) {
		ECacheFactory.me.getCache().setTtl(appendTenant(item.getCacheName()), formatKey(item.getCacheKey()), item.getLiveSeconds());
	}
	
	public static Set<String> getKeys(String cacheName){
		return ECacheFactory.me.getCache().getKeys(appendTenant(cacheName));
	}
	
	/**
	 * 获取缓存（不自动附加domain部分，便于跨租户操作）
	 * @param cacheName 需要经过 appendTenant() 提前处理
	 * @param key
	 */
	public static <T> T getBase(String cacheName, Object key) {
		return ECacheFactory.me.getCache().get(cacheName, formatKey(key));
	}
	
	/**
	 * 添加缓存（不自动附加domain部分，便于跨租户操作）
	 * @param cacheName 需要经过 appendTenant() 提前处理
	 * @param key
	 * @param value
	 */
	public static void putBase(String cacheName, Object key, Object value) {
		ECacheFactory.me.getCache().put(cacheName, formatKey(key), value);
	}
	
	/**
	 * <p>
	 * 清除缓存（不自动附加domain部分，便于跨租户清除）
	 * </p>
	 * 
	 * @param cacheName 需要经过 appendTenant() 提前处理
	 * @param key
	 */
	public static void removeBase(String cacheName, Object key){
		ECacheFactory.me.getCache().remove(cacheName, formatKey(key));
	}
	
	/**
	 * <p>
	 * 清除全部缓存（不自动附加domain部分，便于跨租户清除）
	 * </p>
	 * 
	 * @param cacheName 需要经过 appendTenant() 提前处理
	 */
	public static void removeAllBase(String cacheName){
		ECacheFactory.me.getCache().removeAll(cacheName);
	}
	
	/**
	 * <p>
	 * 清除全部租户的指定缓存（不自动附加domain部分，便于跨租户清除）
	 * </p>
	 * 
	 * @param cacheName 自动遍历所有租户
	 */
	public static void removeGlobal(String cacheName, Object key){
		CompService compSer = Ioc.get(CompService.class);
		List<Comp> comps = compSer.getAllComp();
		comps.forEach(comp -> ECacheFactory.me.getCache().remove(appendTenant(comp.getDomain(), cacheName), formatKey(key)));
	}

}
