package itez.core.util;

import java.lang.reflect.Method;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;

import itez.kit.ELog;
import itez.kit.EStr;

public abstract class BasePropReader {

	public void load(String propFilePath){
		Prop prop = PropKit.use(propFilePath);
		load(prop);
	}

	public void load(Prop prop){
		Class<? extends BasePropReader> clazz = this.getClass();
		List<Method> setMethods = getClassSetMethods(clazz);
		for (Method method : setMethods) {
			String key = EStr.toLowerCaseFirst(method.getName().substring(3));
			String value = prop.get(key);
			if(EStr.isEmpty(value)) continue;
			try {
				Object val = convert(method.getParameterTypes()[0], value);
				method.invoke(this, val);
			} catch (Exception e) {
				ELog.warn(getClass(), e.getMessage());
			}
		}
	}
	
    private List<Method> getClassSetMethods(Class<? extends BasePropReader> clazz) {
    	List<Method> setMethods = Lists.newArrayList();
        Method[] methods = clazz.getMethods();
        for (Method method : methods) {
        	String mname = method.getName();
            if (mname.startsWith("set") && mname.length() > 3 && method.getParameterCount() == 1) {
            	setMethods.add(method);
            }
        }
        return setMethods;
    }

    /**
     * 数据转化
     *
     * @param type
     * @param s
     * @return
     */
    private static final Object convert(Class<?> type, String s) {
        if (type == String.class) {
            return s;
        }
        if (type == Integer.class || type == int.class) {
            return Integer.parseInt(s);
        } else if (type == Long.class || type == long.class) {
            return Long.parseLong(s);
        } else if (type == Double.class || type == double.class) {
            return Double.parseDouble(s);
        } else if (type == Float.class || type == float.class) {
            return Float.parseFloat(s);
        } else if (type == Boolean.class || type == boolean.class) {
            String value = s.toLowerCase();
            if ("1".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            } else if ("0".equals(value) || "false".equals(value)) {
                return Boolean.FALSE;
            } else {
                throw new RuntimeException("Can not parse to boolean type of value: " + s);
            }
        } else if (type == java.math.BigDecimal.class) {
            return new java.math.BigDecimal(s);
        } else if (type == java.math.BigInteger.class) {
            return new java.math.BigInteger(s);
        } else if (type == byte[].class) {
            return s.getBytes();
        }
        throw new RuntimeException(type.getName() + " can not be converted, please use other type in your config class!");
    }
	
}
