package itez.core.runtime.task;

import java.util.Date;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.Scheduler;
import itez.kit.EClass;
import itez.kit.ELog;
import itez.kit.exception.ExceptionKit;
import itez.kit.log.ELogBase;
import itez.plat.main.model.Task;

public class TaskKit {

	private Scheduler scheduler;

	private String id;
	private String dbid;
	private String cron;
	private String clazz;
	private String params;
	private ETask task;
	private boolean daemon;
	
	private static ELogBase log = ELog.log(TaskKit.class);
	
	public TaskKit(Task model){
		dbid = model.getId();
		cron = model.getCron();
		clazz = model.getTaskClass();
		params = model.getTaskParams();
		daemon = model.getDaemon() == 1;
	}
	
	public void schedule() {
		try {
			scheduler = new Scheduler();
			Class<?> cls = EClass.forName(clazz);
			Object t = EClass.newInstance(cls, new Class[]{ String.class }, new Object[]{ params });
			if (t instanceof ETask) {
				task = (ETask) t;
				id = scheduler.schedule(cron, task);
				ESchedulerListener listener = new ESchedulerListener(id, dbid);
				scheduler.addSchedulerListener(listener);
			} else {
				scheduler = null;
				throw new IllegalStateException("Task 必须是ETask 类型：" + clazz);
			}
			scheduler.setDaemon(daemon);
			log.info("成功初始化定时任务：{}", clazz);
		} catch (Exception e) {
			log.error("初始化定时任务出错：{}", clazz);
			log.error(ExceptionKit.getExceptionMore(e));
		}
	}

	public void start() {
		scheduler.start();
	}

	public void stop() {
		task.stop();
		scheduler.stop();
	}
	
	public void reset(String pattern){
		scheduler.reschedule(dbid, pattern);
	}
	
	public String getId() {
		return id;
	}

	public String getDbid() {
		return dbid;
	}
	
	public static Date getNextDate(String pattern){
		Predictor pre = new Predictor(pattern);
		return pre.nextMatchingDate();
	}
	
}
