package itez.core.runtime.task;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.SchedulerListener;
import it.sauronsoftware.cron4j.TaskExecutor;
import itez.core.runtime.service.Ioc;
import itez.kit.ELog;
import itez.kit.exception.ExceptionKit;
import itez.plat.main.service.TaskService;

public class ESchedulerListener implements SchedulerListener {

	private String id;
	private String dbid;
	private static TaskService taskSer = Ioc.get(TaskService.class);
	
	public ESchedulerListener(String id, String dbid){
		this.id = id;
		this.dbid = dbid;
	}
	
	@Override
	public void taskLaunching(TaskExecutor executor) {
		ELog.info("TaskLaunching : id（{}），dbid（{}）", id, dbid);
		Predictor pre = new Predictor(executor.getScheduler().getSchedulingPattern(id));
		taskSer.runBefore(dbid, pre.nextMatchingDate());
	}

	@Override
	public void taskSucceeded(TaskExecutor executor) {
		ELog.info("TaskSucceeded : id（{}），dbid（{}）", id, dbid);
		taskSer.runAfter(dbid, true, "");
	}

	@Override
	public void taskFailed(TaskExecutor executor, Throwable e) {
		String expStr = ExceptionKit.getExceptionMore(e);
		ELog.error("TaskFailed : id（{}），dbid（{}），msg（{}）", id, dbid, expStr);
		taskSer.runAfter(dbid, false, expStr);
	}

}
