package itez.core.runtime.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.servlet.ServletContext;

import itez.core.runtime.service.Ioc;
import itez.kit.EBase64;
import itez.kit.EClass;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.EStr;

public class ESessionDb extends ESessionBase {
	
	ISessionDbService dbService;
	
	public ESessionDb(ServletContext context) {
		id = generateSessionId();
		creationTime = System.currentTimeMillis();
		lastAccessedTime = creationTime;
		maxInactiveInterval  = (int)TimeUnit.MINUTES.toSeconds(SessionTimeOutMinutes);
		servletContext = context;
		dbService = Ioc.get(ISessionDbService.class);
	}

	@Override
	public Object getAttribute(String name) {
		String val = dbService.getValueBySessionName(id, name);
		Object value = null;
		if(EStr.notEmpty(val)){
			try {
				val = EBase64.decode(val);
				String className = val.split("___")[0];
				String json = val.split("___")[1];
				Class<?> clazz = EClass.forName(className);
				value = EJson.parse(json, clazz);
			} catch (Exception e) {
				if(EProp.DevMode) e.printStackTrace();
			}
		}
		return value;
	}

	@Override
	public Enumeration<String> getAttributeNames() {
		List<String> vals = dbService.getSessionNames(id);
		return Collections.enumeration(vals);
	}

	@Override
	public void setAttribute(String name, Object value) {
		String val = null;
		if(value != null){
			try {
				Class<?> clazz = EClass.getUsefulClass(value.getClass());
				val = clazz.getName() + "___" + EJson.toJson(value);
				val = EBase64.encode(val);
			} catch (Exception e) {
				if(EProp.DevMode) e.printStackTrace();
			}
		}
		dbService.setSession(id, name, val);
	}

	@Override
	public void removeAttribute(String name) {
		dbService.removeSession(id, name);
	}

	@Override
	public void invalidate() {
		invalid = true;
		dbService.invalidateSession(id);
	}

}
