package itez.core.runtime.session;

import java.util.Enumeration;
import java.util.concurrent.TimeUnit;

import javax.servlet.ServletContext;

import itez.core.runtime.EContext;
import itez.kit.EBase64;
import itez.kit.EClass;
import itez.kit.ECookie;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.EStr;

public class ESessionCookie extends ESessionBase{
	
	public ESessionCookie(ServletContext context) {
		id = generateSessionId();
		creationTime = System.currentTimeMillis();
		lastAccessedTime = creationTime;
		maxInactiveInterval  = (int)TimeUnit.MINUTES.toSeconds(SessionTimeOutMinutes);
		servletContext = context;
	}

	@Override
	public Object getAttribute(String name) {
		String val = ECookie.getCookie(EContext.getRequest(), getCookieKey(name));
		Object value = null;
		if(EStr.notEmpty(val)){
			try {
				val = EBase64.decode(val);
				String className = val.split("___")[0];
				String json = val.split("___")[1];
				Class<?> clazz = EClass.forName(className);
				value = EJson.parse(json, clazz);
			} catch (Exception e) {
				if(EProp.DevMode) e.printStackTrace();
			}
		}
		return value;
	}

	@Override
	public Enumeration<String> getAttributeNames() {
		return null;
	}

	@Override
	public void setAttribute(String name, Object value) {
		String val = null;
		if(value != null){
			try {
				Class<?> clazz = EClass.getUsefulClass(value.getClass());
				val = clazz.getName() + "___" + EJson.toJson(value);
				val = EBase64.encode(val);
			} catch (Exception e) {
				if(EProp.DevMode) e.printStackTrace();
			}
		}
		ECookie.setCookie(EContext.getResponse(), getCookieKey(name), val, -1, TimeUnit.MINUTES);
	}

	@Override
	public void removeAttribute(String name) {
		ECookie.setCookie(EContext.getResponse(), getCookieKey(name), null, -1, TimeUnit.MINUTES);
		
	}

	@Override
	public void invalidate() {
		ECookie.removeCookie(EContext.getRequest(), EContext.getResponse(), getCookieKey());
	}

}
