package itez.core.runtime.session;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class EServletRequestWrapper extends HttpServletRequestWrapper {
	
    private ESessionBase httpSession;
    //private final byte[] body;
    
	public EServletRequestWrapper(HttpServletRequest request) throws IOException {
		super(request);
		//body = request.getReader().lines().collect(Collectors.joining()).getBytes(EStr.UTF_8);
	}
	
	@Override
	public HttpSession getSession() {
		return getSession(true);
	}
	
	@Override
	public HttpSession getSession(boolean create) {
		return session(create);
	}
	
	/**
	 * <p>
	 * 创建或返回Session对象
	 * </p>
	 * 
	 * @param create
	 * @return
	 */
	public ESessionBase session(boolean create){
		if(httpSession != null){
			return httpSession;
		}else if (create) {
			httpSession = new ESessionDb(getServletContext());

			//仅保留DB方案，其他方案已放弃
//			String sessionPlan = EProp.SessionPlan.toLowerCase();
//			if(sessionPlan.equals("db")){
//				httpSession = new ESessionDb(getServletContext());
//			}else if(sessionPlan.equals("cache")){
//				httpSession = new ESessionCache(getServletContext());
//			}else if(sessionPlan.equals("cookie")){
//				httpSession = new ESessionCookie(getServletContext());
//			}else{
//				throw new ErrException("未设置有效的Session共享方案名称：" + sessionPlan);
//			}
        }
		return httpSession;
	}
	
	/*
	@Override
	public BufferedReader getReader() throws IOException {
		return new BufferedReader(new InputStreamReader(getInputStream()));
	}
	
	@Override
	public ServletInputStream getInputStream() throws IOException {
		final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
		return new ServletInputStream(){
            public int read() throws IOException
            {
                return byteArrayInputStream.read();
            }
			@Override
			public boolean isFinished() {
				return false;
			}
			@Override
			public boolean isReady() {
				return false;
			}
			@Override
			public void setReadListener(ReadListener readListener) {
				
			}
        };
	}
	*/

}
