package itez.core.runtime.session;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.google.common.collect.Maps;

import itez.core.runtime.service.common.IUser;
import itez.kit.EClass;

public class ERequestBean implements Serializable {
	
	private static final long serialVersionUID = -5986057985076638874L;

	private Map<String, String[]> params = Maps.newHashMap(); //请求参数
	private Map<String, Object> attrs = Maps.newHashMap(); //请求属性
	private Map<String, Object> idens = Maps.newHashMap(); //请求身份
	private IUser user = null; //用户对象
	private Class<?> handleService = null; //队列处理服务名称，处理服务必须实现IQueueHandle接口
	private String handleServiceName = null; //队列处理服务类名称，处理服务类必须实现IQueueHandle接口

	public ERequestBean(HttpServletRequest request, Class<?> handleService){
		this.handleService = handleService;
		this.handleServiceName = handleService.getName();
		this.params = request.getParameterMap();
		
		Enumeration<String> attrNames = request.getAttributeNames();
		while(attrNames.hasMoreElements()){
			String name = attrNames.nextElement();
			this.attrs.put(name, request.getAttribute(name));
		}
	}

	public ERequestBean(HttpServletRequest request, String handleServiceName){
		this.handleService = EClass.forName(handleServiceName);
		this.handleServiceName = handleServiceName;
		this.params = request.getParameterMap();
		
		Enumeration<String> attrNames = request.getAttributeNames();
		while(attrNames.hasMoreElements()){
			String name = attrNames.nextElement();
			this.attrs.put(name, request.getAttribute(name));
		}
	}

	public Class<?> getHandleService() {
		return handleService;
	}
	public String getHandleServiceName() {
		return handleServiceName;
	}
	public Object getAttr(String attrName){
		return attrs.get(attrName);
	}
	public Map<String, Object> getAttrs() {
		return attrs;
	}
	public String getParam(String paramName){
		String[] ps = params.get(paramName);
		if(ps != null && ps.length != 0)
			return ps[0];
		else
			return null;
	}
	public String[] getParams(String paramName){
		return params.get(paramName);
	}
	public Map<String, String[]> getAllParams() {
		return params;
	}
	public IUser getUser() {
		return user;
	}
	public ERequestBean setUser(IUser user) {
		this.user = user;
		return this;
	}
	public Object getIden(String key) {
		return idens.get(key);
	}
	public ERequestBean putIden(String key, Object value) {
		idens.put(key, value);
		return this;
	}

}
