package itez.core.runtime.service.interceptor.cache;

import itez.core.runtime.service.interceptor.cache.ServiceCache.CacheType;
import itez.kit.cache.ICacheItem;

public class ServiceCacheItem implements ICacheItem {
	
	private CacheType cacheType;
	
	private String cacheName = null;
	private String cacheNames = null;
	private String cacheKey = null;
	private String cacheKeys = null;

	private Object cacheValue = null;
	private int liveSeconds = 0;

	public ServiceCacheItem(String cacheName, String cacheKey){
		this.cacheName = cacheName;
		this.cacheKey = cacheKey;
	}

	public ServiceCacheItem(CacheType cacheType, String cacheName){
		this.cacheType = cacheType;
		this.cacheName = cacheName;
	}

	public ServiceCacheItem(CacheType cacheType, String cacheName, String cacheKey){
		this.cacheType = cacheType;
		this.cacheName = cacheName;
		this.cacheKey = cacheKey;
	}

	public ServiceCacheItem(CacheType cacheType, String cacheName, String cacheKey, String cacheKeys){
		this.cacheType = cacheType;
		this.cacheName = cacheName;
		this.cacheKey = cacheKey;
		this.cacheKeys = cacheKeys;
	}

	public void setCacheValue(Object cacheValue) {
		this.cacheValue = cacheValue;
	}
	
	public CacheType getCacheType() {
		return cacheType;
	}
	
	public String getCacheName() {
		return cacheName;
	}

	public String getCacheNames() {
		return cacheNames;
	}

	public String getCacheKey() {
		return cacheKey;
	}
	
	public String getCacheKeys() {
		return cacheKeys;
	}

	public void setCacheKeys(String cacheKeys) {
		this.cacheKeys = cacheKeys;
	}

	public Object getCacheValue() {
		return cacheValue;
	}
	
	public int getLiveSeconds() {
		return liveSeconds;
	}

}
