package itez.core.runtime.service.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.service.interceptor.cache.ServiceCache;

/**
 * 业务层拦截器：缓存实现
 * 
 * @author netwild
 *
 */
public class CacheInterceptor implements Interceptor {
	
	//private final static ELogBase log = ELog.log(CacheInterceptor.class);
	//private final static Integer methodInvWarnCount = 10;
	//private final Map<String, Integer> methodsInvCount = new ConcurrentHashMap<>();
	
	@Override
	public void intercept(Invocation inv) {
		
		//初始化缓存配置对象
		ServiceCache cache = new ServiceCache(inv);
		
		//如果允许使用缓存，则尝试直接从缓存返回方法执行结果
		if(cache.hasReturn() && cache.hasCache()){
			Object ret = cache.getCacheAble();
			if(null != ret){
				inv.setReturnValue(ret);
				return;
			}
		}
		
		//未命中缓存，执行方法体，并保存执行结果
		inv.invoke();
		if(cache.hasReturn()) {
			Object ret = inv.getReturnValue();
			cache.setMethodReturn(ret);
		}
		
		//如果允许使用缓存，则尝试对执行结果进行相应的处理
		if(cache.hasCache()) cache.putCacheAble();
		
		//方法引用计数
		/*
		if(!cache.hasCache()){
			String methodName = EClass.getMethodFullPath(inv.getMethod());
			Integer count = methodsInvCount.containsKey(methodName) ? methodsInvCount.get(methodName) : 0;
			methodsInvCount.put(methodName, ++count);
			if(count > methodInvWarnCount){
				log.info("【优化提醒】方法[{}]已累计调用“{}”次，对于常用方法建议添加缓存，来减轻服务器压力。", methodName, count);
			}
		}
		*/
	}
}