package itez.core.runtime.service.interceptor;

import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.core.Controller;

import itez.kit.EClass;

public class AopInterceptor implements MethodInterceptor {
	
	private static final Interceptor[] INTERS = {
            new CacheInterceptor()
    };

	@Override
	public Object invoke(MethodInvocation inv) throws Throwable {
        Class<?> targetClass = EClass.getUsefulClass(inv.getThis().getClass());
        
        if (Controller.class.isAssignableFrom(targetClass)) return inv.proceed();
        
        Method method = inv.getMethod();
        Interceptor[] interceptors = InterceptorManager.me().buildServiceMethodInterceptor(INTERS, targetClass, method);
        EBeforeInvocation invocation = new EBeforeInvocation(inv, interceptors, inv.getArguments());
        invocation.invoke();
        
        return invocation.getReturnValue();
	}

}
