package itez.core.runtime.service.common;

import java.util.List;

import com.jfinal.plugin.activerecord.Record;

public interface IUserService {

	/**
	 * 根据用户ID查找用户账号（跨域）
	 * @param userId
	 * @return
	 */
	public IUser findById(String userId);
	
	/**
	 * 根据emial查找用户账号
	 * @param email
	 * @return
	 */
	public IUser findByEmail(String email);
	
	/**
	 * 根据手机号码查找用户账号
	 * @param phone
	 * @return
	 */
	public IUser findByPhone(String phone);
	
	/**
	 * 根据身份证号查找用户账号
	 * @param idNum
	 * @return
	 */
	public IUser findByIdNum(String idNum);
	
	/**
	 * 根据工号/学号查找用户账号
	 * @param num
	 * @return
	 */
	public IUser findByNum(String num);
	
	/**
	 * 根据登录名查找用户账号
	 * @param loginName
	 * @return
	 */
	public IUser findByLogin(String loginName);
	
	/**
	 * 根据用户名和密码查找用户账号
	 * @param loginName
	 * @param passWord
	 * @return
	 */
	public IUser findByLogin(String loginName, String passWord);
	
	/**
	 * 根据指定字段查找用户账号
	 * @param deptId
	 * @param type
	 * @param member
	 * @param fieldName
	 * @param keyword
	 * @return
	 */
	public List<Record> findByField(String deptId, String type, Integer member, String fieldName, String keyword);

	
	//////////////////////////////
	
	
	/**
	 * 验证指定用户是否满足某个角色
	 * @param user
	 * @param roleCode
	 * @return
	 */
	public boolean checkRole(IUser user, String roleCode);
	
	/**
	 * 验证指定用户是否同时满足多个角色
	 * @param user
	 * @param roleCodeArr
	 * @return
	 */
	public boolean checkRoles(IUser user, String... roleCodeArr);
	
	/**
	 * 验证指定用户是否满足多个角色之一
	 * @param user
	 * @param roleCodeArr
	 * @return
	 */
	public boolean checkRolesAny(IUser user, String... roleCodeArr);
	
	/**
	 * 验证指定用户是否满足某个权限
	 * @param user
	 * @param permCode
	 * @return
	 */
	public boolean checkPerm(IUser user, String permCode);
	
	/**
	 * 验证指定用户是否同时满足多个权限
	 * @param user
	 * @param permCodeArr
	 * @return
	 */
	public boolean checkPerms(IUser user, String... permCodeArr);
	
	/**
	 * 验证指定用户是否满足多个权限之一
	 * @param user
	 * @param permCodeArr
	 * @return
	 */
	public boolean checkPermsAny(IUser user, String... permCodeArr);
	
}
