package itez.core.runtime.service.common;

import java.util.Date;

import itez.plat.main.model.Dept;

/**
 * 用户接口，所有的User对象都继承于IUser接口
 * 
 * @author netwild
 *
 */
public interface IUser {

	/**
	 * 返回用户ID
	 * @return 用户ID
	 */
	public String getId();
	
	/**
	 * 返回用户子域
	 * @return 子域
	 */
	public String getDomain();
	
	/**
	 * 返回用户唯一标识（身份证号、统一信用代码等）
	 * @return 唯一标识（身份证号、统一信用代码等）
	 */
	public String getIdNum();
	
	/**
	 * 返回内部编号（学号、工号等）
	 * @return 内部编号（学号、工号等）
	 */
	public String getNum();
	
	/**
	 * 返回姓名
	 * @return 姓名
	 */
	public String getCaption();
	
	/**
	 * 返回头像图片地址
	 * @return 头像图片地址
	 */
	public String getHeader();
	
	/**
	 * 返回用户Emial
	 * @return Emial
	 */
	public String getEmail();
	
	/**
	 * 返回手机号码
	 * @return 手机号码
	 */
	public String getPhone();
	
	/**
	 * 返回用户私盐
	 * @return 私盐
	 */
	public String getSalt();
	
	/**
	 * 返回出生日期
	 * @return 出生日期
	 */
	public Date getBirthday();
	
	/**
	 * 返回性别
	 * @return 性别
	 */
	public String getSex();
	
	/**
	 * 返回用户级别
	 * @return 0普通用户，1租户管理员，2超级管理员
	 */
	public Integer getLevel();
	
	/**
	 * 返回用户的根机构（如果是管理员，则返回当前租户的根机构；否则如果存在管辖，则返回管辖机构ID；否则返回本身所在机构ID）
	 * @return 根机构
	 */
	public Dept getDept();
	
	/**
	 * 返回用户的实际机构ID
	 * @return 机构ID
	 */
	public String getDeptId();
	
	/**
	 * 返回用户的根机构ID（如果是管理员，则返回当前租户的根机构；否则如果存在管辖，则返回管辖机构ID；否则返回本身所在机构ID）
	 * @return 根机构ID
	 */
	public String getRootDeptId();
	
	/**
	 * 返回用户是否可用
	 * @return 0已禁用，1正常
	 */
	public Integer getUsed();
	
	/**
	 * 返回用户的自定义类型
	 * @return 类型
	 */
	public String getType();
	
	/**
	 * 返回注册类型
	 * @return 类型
	 */
	public String getRegType();
	
	/**
	 * 用户登录密码校验
	 * @param password 输入的登录密码
	 * @return 校验结果
	 */
	public boolean checkPass(String password);
	
	/**
	 * 租户管理员校验
	 * @return 校验结果
	 */
	public boolean checkAdmin();
	
	/**
	 * 超级管理员校验
	 * @return 校验结果
	 */
	public boolean checkSupAdmin();
	
	/**
	 * 鉴权方法：单个角色
	 * @param roleCode 角色代码
	 * @return 鉴权结果
	 */
	public boolean checkRole(String roleCode);
	
	/**
	 * 鉴权方法：同时满足多个角色
	 * @param roleCodeArr 角色代码数组
	 * @return 鉴权结果
	 */
	public boolean checkRoles(String... roleCodeArr);
	
	/**
	 * 鉴权方法：满足任一角色
	 * @param roleCodeArr 角色代码数组
	 * @return 鉴权结果
	 */
	public boolean checkRolesAny(String... roleCodeArr);
	
	/**
	 * 鉴权方法：单个权限
	 * @param permCode 权限代码
	 * @return 鉴权结果
	 */
	public boolean checkPerm(String permCode);
	
	/**
	 * 鉴权方法：同时满足多个权限
	 * @param permCodeArr 权限代码数组
	 * @return 鉴权结果
	 */
	public boolean checkPerms(String... permCodeArr);
	
	/**
	 * 鉴权方法：满足任一权限
	 * @param permCodeArr 权限代码数组
	 * @return 鉴权结果
	 */
	public boolean checkPermsAny(String... permCodeArr);
	
}
