package itez.core.runtime.service;

import java.util.List;

import itez.core.runtime.service.ETreeService.SORT_DIR;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Querys;

/**
 * <p>
 * 树型服务接口
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年9月30日 下午9:17:44
 */
public interface ITreeService<M extends EModel<M>> extends IModelService<M> {

	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param pid
	 * @return
	 */
	public M getLast(String pid);
	
	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param qs
	 * @param pid
	 * @return
	 */
	public M getLast(Querys qs, String pid);

	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param domain
	 * @param qs
	 * @param pid
	 * @return
	 */
	public M getLast(String domain, Querys qs, String pid);

	/**
	 * 返回前一个兄弟节点
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param sort 当前节点序号
	 * @return
	 */
	public M getPerv(Querys qs, String pid, Integer sort);

	/**
	 * 返回后一个兄弟节点
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param sort 当前节点序号
	 * @return
	 */
	public M getNext(Querys qs, String pid, Integer sort);

	/**
	 * 返回指定的多个节点
	 * @param ids 节点ID，多个ID时用逗号隔开
	 * @param orderby 排序方式（asc/desc）
	 * @return
	 */
	public List<M> getByIds(String ids, String orderby);

	/**
	 * 调序
	 * @param pid 父节点ID
	 * @param dir 调序方向（UP/DOWN）
	 * @param ids 要进行调序的节点ID，多个ID时用逗号隔开
	 */
	public void sort(String pid, SORT_DIR dir, String ids);

	/**
	 * 排序
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param dir 调序方向（UP/DOWN）
	 * @param ids 要进行调序的节点ID，多个ID时用逗号隔开
	 */
	public void sort(Querys qs, String pid, SORT_DIR dir, String ids);

	/**
	 * 整理节点。当节点被移动到其他父节点时引用，将会对该节点下的全部子节点重新定义层次关系
	 * @param qs 自定义条件
	 * @param id 要整理的父节点ID
	 */
	public void arrange(Querys qs, String id);
	
}
