package itez.core.runtime.service;

import java.sql.SQLException;
import java.util.List;

import com.jfinal.plugin.activerecord.IAtom;

import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EStr;

/**
 * <p>
 * 树型服务基类
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年9月30日 下午9:18:07
 */
public abstract class ETreeService<M extends EModel<M>> extends EModelService<M> {
	
	/**
	 * 排序方向
	 * @author netwild
	 *
	 */
	public static enum SORT_DIR { 
		UP, DOWN;
		public String getOrder(){
			return this == UP ? "asc" : "desc";
		}
	};
	
	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param pid
	 * @return
	 */
	public M getLast(String pid){
		return getLast(null, pid);
	}
	
	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param qs
	 * @param pid
	 * @return
	 */
	public M getLast(Querys qs, String pid){
		return getLast($domain(), qs, pid);
	}
	
	/**
	 * 返回指定父节点下的最后一个子节点
	 * @param domain
	 * @param qs
	 * @param pid
	 * @return
	 */
	public M getLast(String domain, Querys qs, String pid){
		Querys querys = Querys.and(Query.eq("domain", domain));
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid));
		return selectFirst(querys, "sort desc", false);
	}
	
	/**
	 * 返回前一个兄弟节点
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param sort 当前节点序号
	 * @return
	 */
	public M getPerv(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid)).add(Query.lt("sort", sort));
		return selectFirst(querys, "sort desc");
	}

	/**
	 * 返回后一个兄弟节点
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param sort 当前节点序号
	 * @return
	 */
	public M getNext(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(EStr.isEmpty(pid) ? Query.nu("pid") : Query.eq("pid", pid)).add(Query.gt("sort", sort));
		return selectFirst(querys, "sort");
	}
	
	/**
	 * 返回指定的多个节点
	 * @param ids 节点ID，多个ID时用逗号隔开
	 * @param orderby 排序方式（asc/desc）
	 * @return
	 */
	public List<M> getByIds(String ids, String orderby){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	/**
	 * 调序
	 * @param pid 父节点ID
	 * @param dir 调序方向（UP/DOWN）
	 * @param ids 要进行调序的节点ID，多个ID时用逗号隔开
	 */
	public void sort(String pid, SORT_DIR dir, String ids){
		sort(null, pid, dir, ids);
	}
	
	/**
	 * 排序
	 * @param qs 自定义条件
	 * @param pid 父节点ID
	 * @param dir 调序方向（UP/DOWN）
	 * @param ids 要进行调序的节点ID，多个ID时用逗号隔开
	 */
	public void sort(Querys qs, String pid, SORT_DIR dir, String ids){
		List<M> list = getByIds(ids, dir.getOrder());
		if(dir == SORT_DIR.UP){
			M perv = getPerv(qs, pid, list.get(0).getInt("sort"));
			if(perv == null) return;
		}else{
			M next = getNext(qs, pid, list.get(0).getInt("sort"));
			if(next == null) return;
		}
		list.forEach(item -> {
			sort(qs, pid, dir, item);
		});
	}
	
	private void sort(Querys qs, String pid, SORT_DIR dir, M item){
		M side = (dir == SORT_DIR.UP ? getPerv(qs, pid, item.getInt("sort")) : getNext(qs, pid, item.getInt("sort")));
		Integer sideSort = side.getInt("sort");
		String sidePath = side.get("path");
		Integer itemSort = item.getInt("sort");
		String itemPath = item.get("path");
		item.set("sort", sideSort);
		item.set("path", sidePath);
		side.set("sort", itemSort);
		side.set("path", itemPath);
		update(item);
		update(side);
		Querys qsSide = Querys.and().add(Query.like("path", sidePath + "_%"));
		Querys qsItem = Querys.and().add(Query.like("path", itemPath + "_%"));
		if(qs != null){
			qsSide.add(qs);
			qsItem.add(qs);
		}
		List<M> listSide = select(qsSide);
		listSide.forEach(d -> {
			d.set("path", d.getStr("path").replace(sidePath, itemPath));
		});
		List<M> listItem = select(qsItem);
		listItem.forEach(d -> {
			d.set("path", d.getStr("path").replace(itemPath, sidePath));
		});
		dbo().tx(new IAtom() {
			@Override
			public boolean run() throws SQLException {
				int[] b1 = dbo().batchUpdate(listSide, listSide.size());
				int[] b2 = dbo().batchUpdate(listItem, listItem.size());
				return EArr.vali(b1, b2);
			}
		});
	}
	
	/**
	 * 整理节点。当节点被移动到其他父节点时引用，将会对该节点下的全部子节点重新定义层次关系
	 * @param qs 自定义条件
	 * @param id 要整理的父节点ID
	 */
	public void arrange(Querys qs, String id){
		M item = findById(id);
		String pathOrig = item.getStr("path");
		
		String pid = item.getStr("pid");
		M parent = EStr.isEmpty(pid) ? null : findById(pid);
		M last = getLast(qs, pid); //获取当前父节点的最后一个子节点
		
		Integer sort = last == null ? 1 : EStr.ifNull(last.getInt("sort"), 0) + 1;
		String path = parent == null ? EStr.addPrefix(sort, 3) : String.format("%s_%s", parent.getStr("path"), EStr.addPrefix(sort, 3));
		
		item.set("sort", sort).set("path", path);
		update(item);
		
		if(EStr.isEmpty(pathOrig)) return;
		
		Querys qsSub = Querys.and().add(Query.like("path", pathOrig + "_%"));
		if(qs != null) qsSub.add(qs);
		List<M> listSub = select(qsSub);
		listSub.forEach(d -> {
			d.set("path", d.getStr("path").replace(pathOrig, path));
		});
		batchUpdate(listSub);
	}
	
}
