package itez.core.runtime.cache;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 业务逻辑缓存注解
 * 
 * @author netwild
 *
 */
public @interface Cache {

	/**
	 * 对该方法启用缓存
	 * 如果缓存中存在该方法的返回值，则直接返回，不执行方法。
	 * 否则执行方法后，如果未抛出异常，则将返回值添加到缓存，下次调用方法时，可直接返回。
	 * 
	 * 其中：
	 *   cache: (默认) ClassPackage.ClassName.MethodName(Parameter1.Type,Parameter2.Type...ParameterX.Type)
	 *   Key: (默认) Parameter1.HashCode,Parameter2.HashCode...Parameter3.HashCodeX
	 *   
	 * 参数：
	 *   
	 *   cache：自定义cacheName
	 *   key: 自定义cacheKey表达式
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	public static @interface able{ String cache() default ""; String key() default ""; }

	/**
	 * 仅将方法的返回值添加到缓存
	 * 
	 * 具体调用同ECache.able
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	public static @interface put{ String cache() default ""; String key() default ""; }

	/**
	 * 从缓存中移除单条记录，支持重复引用。
	 * 
	 * 具体调用同ECache.able 
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	@Repeatable(Cache.dels.class)
	public static @interface del{ String cache() default ""; String key() default ""; String keys() default ""; }

	/**
	 * 用于重复移除单条时的注解集合，不可以直接引用
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	public static @interface dels{ Cache.del[] value(); }

	/**
	 * 从缓存中移除指定CacheName下的全部记录，支持重复引用。
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	@Repeatable(Cache.delAlls.class)
	public static @interface delAll{ String cache() default ""; }

	/**
	 * 用于重复移除多条时的注解集合，不可以直接引用
	 * 
	 * @author netwild
	 *
	 */
	@Inherited
	@Retention(RetentionPolicy.RUNTIME)
	@Target({ ElementType.METHOD })
	public static @interface delAlls{ Cache.delAll[] value(); }
	
}
