package itez.core.runtime;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import itez.core.runtime.session.EAttr;
import itez.core.runtime.session.EServletRequestWrapper;
import itez.core.runtime.session.ESessionBase;

/**
 * JWinner上下文线程处理
 * 将会话中经常使用的相关对象绑定到线程，方便在各层随时调用
 * 
 * @author netwild
 *
 */
public class EContext {

	private static ThreadLocal<HttpServletRequest> requests = new ThreadLocal<>();
	private static ThreadLocal<HttpServletResponse> responses = new ThreadLocal<>();
	private static ThreadLocal<EAttr> attrs = new ThreadLocal<>();

	public static void bind(EAttr attr, HttpServletRequest request, HttpServletResponse response) {
		attrs.set(attr);
		requests.set(request);
		responses.set(response);
	}
	
	public static HttpServletRequest getRequest(){
		return requests.get();
	}
	
	public static HttpServletResponse getResponse(){
		return responses.get();
	}
	
	public static EAttr getAttr(){
		return attrs.get();
	}
	
	public static ESessionBase getSession(){
		return (ESessionBase) getRequest().getSession();
	}
	
	public static void release(){
		requests.remove();
		responses.remove();
		attrs.remove();
	}
	
	public static void releaseAttr(){
		attrs.remove();
	}
	
    @SuppressWarnings("unchecked")
	public static <T> T getRequestAttr(String key) {
    	EServletRequestWrapper request = (EServletRequestWrapper) getRequest();
        if (request == null) return null;
        return (T) request.getAttribute(key);
    }

    public static void setRequestAttr(String key, Object value) {
    	EServletRequestWrapper request = (EServletRequestWrapper) getRequest();
        if (request == null) return;
        request.setAttribute(key, value);
    }
	
}
