package itez.core.launch;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.jfinal.core.JFinalFilter;

import itez.core.license.LicenseAuth;
import itez.core.license.LicenseException;
import itez.core.license.LicenseException.Code;
import itez.core.runtime.session.EServletRequestWrapper;
import itez.kit.ELog;
import itez.kit.log.ELogBase;

public class JWinnerFilter extends JFinalFilter {

	private static final ELogBase log = ELog.log(JWinnerFilter.class);
	
	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		try {
			String expire = LicenseAuth.vali();
			JW.LicenseVali = true;
			log.info("JWinner授权有效[{}]", expire);
			super.init(filterConfig);
		} catch (LicenseException e) {
			Code ec = e.getErrCode();
			if(ec == Code.NOLICENSE){
				log.error("抱歉，您还未经过上游科技的授权，无法运行JWinner！");
			}else if(ec == Code.ERROR){
				log.error("抱歉，您的授权码错误，无法运行JWinner！");
			}else if(ec == Code.EXPIRE){
				log.error("抱歉，您的授权已过期，请重新申请！");
			}
			log.error("授权方式：通过您的 [本地码] 向上游科技获取 [授权码] ，将其添加到配置文件的 [License] 选项即可。");
			log.error("您的本地码 [" + e.getLocalCode() + "]");
			log.error("上游科技官网：www.itez.com.cn");
		}
	}
	
	@Override
	public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest)req;
		EServletRequestWrapper reqWrap = new EServletRequestWrapper(request);
		super.doFilter(reqWrap, res, chain);
	}
	
}
