package itez.core.launch;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.json.MixedJsonFactory;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ClassPathSourceFactory;

import itez.core.runtime.modules.ModuleManager;
import itez.core.wrapper.controller.EControllerFactory;
import itez.core.wrapper.cross.CrossOriginInterceptor;
import itez.core.wrapper.dbo.DbManager;
import itez.core.wrapper.handler.EActionHandler;
import itez.core.wrapper.handler.EDomainHandler;
import itez.core.wrapper.interceptor.AuthInterceptor;
import itez.kit.EProp;
import itez.kit.El;
import itez.kit.log.ELogFactory;
import itez.kit.server.LocalServer;
import itez.kit.server.LocalServerFactory;

public abstract class JWinnerConfig extends JFinalConfig {

	/**
	 * 全局参数配置
	 */
	public void configConstant(Constants me) {
		me.setEncoding(EProp.Charset);
		me.setDevMode(EProp.DevMode);
		me.setBaseUploadPath(EProp.FileUploadTemp);
		me.setMaxPostSize(EProp.MaxPostSize);
		me.setLogFactory(ELogFactory.me);
		me.setJsonFactory(new MixedJsonFactory());
		me.setControllerFactory(new EControllerFactory());
		me.setError404View(EProp.TempCommonPath + "/err404.html");
		me.setError500View(EProp.TempCommonPath + "/err500.html");
	}
	
	/**
	 * 路由配置
	 */
	public void configRoute(Routes me) {
		me.setMappingSuperClass(true);
		ModuleManager.me.deployControllers(me);
	}

	/**
	 * 模板引擎配置
	 */
	public void configEngine(Engine me) {
		me.setDevMode(EProp.DevMode);
		me.setSourceFactory(new ClassPathSourceFactory());
		me.setBaseTemplatePath("/META-INF/resources");
		El.addSharedObject(me);
	}

	/**
	 * 插件配置
	 */
	public void configPlugin(Plugins me) {
		DbManager.me.initDBPlugins(me); //初始化数据库模型ARP插件
	}

	/**
	 * 拦截器配置
	 */
	public void configInterceptor(Interceptors me) {
		me.addGlobalActionInterceptor(new AuthInterceptor()); //鉴权拦截器：用户身份Token管理、控制器鉴权
		if(EProp.CrossOrigin) me.addGlobalActionInterceptor(new CrossOriginInterceptor()); //跨域注解拦截器
	}

	/**
	 * 资源访问模型
	 */
	public void configHandler(Handlers me) {
		me.setActionHandler(new EActionHandler()); //默认Handle，实现Action映射、FlashMessage等
		me.add(new EDomainHandler()); //域名解析、公司信息初始化、WEB防火墙、本次请求的会话生命周期管理（ESession）
	}
	
	/**
	 * 框架启动完成后执行
	 */
	public void onStart() {
	}
	
	/**
	 * 以80端口启动服务
	 */
	protected static final void debug(){
		LocalServerFactory.me.start();
	}

	
	/**
	 * 以80端口启动服务
	 */
	protected static final void debug(LocalServer server){
		server.start();
	}
	
}
